/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.migration;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.spaces.SpaceManager;
import com.google.common.base.Preconditions;
import eps.focuspro.DropdownSet.DropdownSet;
import eps.focuspro.DropdownSet.Options.TextOption;
import eps.focuspro.configui.spaceconfig.SpaceSettings;
import eps.focuspro.edm.persistence.SetEntityAccessor;
import eps.focuspro.migration.MigrationTask;
import eps.focuspro.migration.TextSetSettingsConverter;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextMigrationTaskInvoker {
    private final TextSetSettingsConverter textSetSettingsConverter;
    private final SpaceManager spaceManager;
    private final SpaceSettings spaceSettings;
    private final ActiveObjects ao;
    private final SetEntityAccessor setEntityAccessor;
    private static final Logger log = LoggerFactory.getLogger(TextMigrationTaskInvoker.class);

    public TextMigrationTaskInvoker(TextSetSettingsConverter textSetSettingsConverter, SpaceManager spaceManager, SpaceSettings spaceSettings, ActiveObjects ao, SetEntityAccessor setEntityAccessor) {
        this.textSetSettingsConverter = textSetSettingsConverter;
        this.spaceManager = spaceManager;
        this.spaceSettings = spaceSettings;
        this.ao = (ActiveObjects)Preconditions.checkNotNull((Object)ao);
        this.setEntityAccessor = setEntityAccessor;
    }

    public void workGlobal() {
        if (this.setEntityAccessor.areThereNoTextSetsPresent("")) {
            log.info("Starting Global Text Set Migration");
            this.migrateGlobalTextSettings();
            log.info("Finished Global Text Set Migration");
        } else {
            log.info("Didn't migrate global text sets from plugin settings as there were already sets present!");
        }
    }

    public void workForSpace(String spaceKey) {
        if (!this.spaceSettings.loadOptions(spaceKey).isEmpty()) {
            if (this.setEntityAccessor.areThereNoTextSetsPresent(spaceKey)) {
                log.info("Starting text set migration of space: " + spaceKey);
                this.startSpaceMigrationTask(spaceKey);
                log.info("Finished status set migration of space: " + spaceKey);
            } else {
                log.info("Didn't migrate text sets from plugin settings of space: " + spaceKey + " because there was already data in active objects found");
            }
        } else {
            log.info("There are no sets in the space: " + spaceKey);
        }
    }

    private void migrateGlobalTextSettings() {
        MigrationTask<Map<String, String>, List<DropdownSet<TextOption>>, Map<String, String>, Map<String, Map<String, String>>> migrationTask = new MigrationTask<Map<String, String>, List<DropdownSet<TextOption>>, Map<String, String>, Map<String, Map<String, String>>>();
        migrationTask.setLoader(this.textSetSettingsConverter.createGlobalSettingsSupplier);
        migrationTask.setConverter(this.textSetSettingsConverter.createNewSets);
        migrationTask.setSetMapper(this.textSetSettingsConverter.setMappingFunction);
        migrationTask.setOptionsMapper(this.textSetSettingsConverter.textOptionsMapping);
        migrationTask.setSetSaver(this.textSetSettingsConverter.globalSetSaver);
        migrationTask.setMappingSaver(this.textSetSettingsConverter.globalMappingSaver);
        migrationTask.migrate();
    }

    private void startSpaceMigrationTask(String spaceKey) {
        MigrationTask<Map<String, String>, List<DropdownSet<TextOption>>, Map<String, String>, Map<String, Map<String, String>>> migrationTask = new MigrationTask<Map<String, String>, List<DropdownSet<TextOption>>, Map<String, String>, Map<String, Map<String, String>>>();
        migrationTask.setLoader(this.textSetSettingsConverter.createSpaceSettingsSupplier(spaceKey));
        migrationTask.setConverter(this.textSetSettingsConverter.createNewSets);
        migrationTask.setSetMapper(this.textSetSettingsConverter.setMappingFunction);
        migrationTask.setOptionsMapper(this.textSetSettingsConverter.textOptionsMapping);
        migrationTask.setSetSaver(this.textSetSettingsConverter.spaceSetSaver(spaceKey));
        migrationTask.setMappingSaver(this.textSetSettingsConverter.spaceMappingSaver(spaceKey));
        migrationTask.migrate();
    }
}

