/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.migration;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import eps.focuspro.database.SaveFailCatcher;
import java.util.HashMap;
import java.util.Map;

public class MigrationDatabase {
    private final BandanaManager bandanaManager;
    private final SaveFailCatcher saveFailCatcher;

    public MigrationDatabase(BandanaManager bandanaManager, SaveFailCatcher saveFailCatcher) {
        this.bandanaManager = bandanaManager;
        this.saveFailCatcher = saveFailCatcher;
    }

    public Map<String, String> getGlobalSetsMapping(String key) {
        Object setMapObject = this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), key);
        if (setMapObject == null) {
            return new HashMap<String, String>();
        }
        Map setMap = (Map)setMapObject;
        return new HashMap<String, String>(setMap);
    }

    public void saveGlobalSetsMapping(Map<String, String> globalSetMapping, String key) {
        this.saveFailCatcher.save(() -> this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), key, (Object)globalSetMapping));
    }

    public Map<String, Map<String, String>> getGlobalOptionsMapping(String key) {
        Object optionMapObject = this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), key);
        if (optionMapObject == null) {
            return new HashMap<String, Map<String, String>>();
        }
        Map optionMap = (Map)optionMapObject;
        return new HashMap<String, Map<String, String>>(optionMap);
    }

    public void saveGlobalOptionsMapping(Map<String, Map<String, String>> globalSetMapping, String key) {
        this.saveFailCatcher.save(() -> this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), key, (Object)globalSetMapping));
    }

    public Map<String, String> getSpaceSetsMapping(String spaceKey, String key) {
        Object setMapObject = this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(spaceKey), key);
        if (setMapObject == null) {
            return new HashMap<String, String>();
        }
        Map setMap = (Map)setMapObject;
        return new HashMap<String, String>(setMap);
    }

    public void saveSpaceSetsMapping(String spaceKey, Map<String, String> spaceSetMapping, String key) {
        this.saveFailCatcher.save(() -> this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(spaceKey), key, (Object)spaceSetMapping));
    }

    public Map<String, Map<String, String>> getSpaceOptionsMapping(String spaceKey, String key) {
        Object optionMapObject = this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(spaceKey), key);
        if (optionMapObject == null) {
            return new HashMap<String, Map<String, String>>();
        }
        Map optionMap = (Map)optionMapObject;
        return new HashMap<String, Map<String, String>>(optionMap);
    }

    public void saveSpaceOptionsMapping(String spaceKey, Map<String, Map<String, String>> globalSetMapping, String key) {
        this.saveFailCatcher.save(() -> this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(spaceKey), key, (Object)globalSetMapping));
    }
}

