/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.fix.task;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskServlet
extends HttpServlet {
    private final SoyTemplateRenderer soyTemplateRenderer;
    private static final Logger log = LoggerFactory.getLogger(TaskServlet.class);
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;

    public TaskServlet(SoyTemplateRenderer soyTemplateRenderer, UserManager userManager, LoginUriProvider loginUriProvider) {
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        try {
            this.enforcePermissions(req, resp);
        }
        catch (Exception e) {
            log.warn("Error enforcing Permissions", (Throwable)e);
        }
        resp.setContentType("text/html;charset=UTF-8");
        String webResource = "eps.focuspro.EasyDropdownMenu:edm-duplication-bug-webresource";
        String EDM_BUG_RESOLVE_TEMPLATE = "Confluence.Edm.Bug.doGet";
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("context_path", req.getContextPath());
        try {
            this.soyTemplateRenderer.render((Appendable)resp.getWriter(), webResource, EDM_BUG_RESOLVE_TEMPLATE, data);
        }
        catch (Exception e) {
            log.error("Error in Task Servlet", (Throwable)e);
        }
    }

    private void enforcePermissions(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        UserKey userKey = this.userManager.getRemoteUserKey(req);
        if (userKey == null) {
            resp.sendRedirect(this.loginUriProvider.getLoginUri(URI.create(req.getRequestURL().toString())).toASCIIString());
        } else if (!this.userManager.isAdmin(userKey)) {
            resp.sendError(404);
        }
    }
}

