/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.edm.persistence;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceStatus;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import eps.focuspro.edm.persistence.config.daos.SchemaVersionHandler;
import eps.focuspro.edm.persistence.config.migration.LogLevelService;
import eps.focuspro.edm.persistence.config.migration.Version1MappingsMigrator;
import eps.focuspro.migration.ActiveObjectsMigrator;
import eps.focuspro.migration.StatusMigrationTaskInvoker;
import eps.focuspro.migration.TextMigrationTaskInvoker;
import eps.focuspro.rest.helper.MigrationInProgressException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigratorGeneral {
    private static final String EDM_MIGRATION_CLUSTER_LOCK = "easy-dropdown-menu-migration-cluster-lock";
    private static final Logger log = LoggerFactory.getLogger(MigratorGeneral.class);
    private final ClusterLockService clusterLockService;
    private final SchemaVersionHandler schemaVersionHandler;
    private final StatusMigrationTaskInvoker statusMigrationTaskInvoker;
    private final TextMigrationTaskInvoker textMigrationTaskInvoker;
    private final ActiveObjectsMigrator activeObjectsMigrator;
    private final Version1MappingsMigrator version1MappingsMigrator;
    private final SpaceManager spaceManager;
    private final TransactionTemplate transactionTemplate;
    private final AccessModeService accessModeService;
    private final LogLevelService logLevelService;

    public MigratorGeneral(ClusterLockService clusterLockService, SchemaVersionHandler schemaVersionHandler, StatusMigrationTaskInvoker statusMigrationTaskInvoker, TextMigrationTaskInvoker textMigrationTaskInvoker, ActiveObjectsMigrator activeObjectsMigrator, Version1MappingsMigrator version1MappingsMigrator, SpaceManager spaceManager, TransactionTemplate transactionTemplate, AccessModeService accessModeService, LogLevelService logLevelService) {
        this.clusterLockService = clusterLockService;
        this.schemaVersionHandler = schemaVersionHandler;
        this.statusMigrationTaskInvoker = statusMigrationTaskInvoker;
        this.textMigrationTaskInvoker = textMigrationTaskInvoker;
        this.activeObjectsMigrator = activeObjectsMigrator;
        this.version1MappingsMigrator = version1MappingsMigrator;
        this.spaceManager = spaceManager;
        this.transactionTemplate = transactionTemplate;
        this.accessModeService = accessModeService;
        this.logLevelService = logLevelService;
    }

    public void check() {
        int schemaVersion = this.schemaVersionHandler.getGlobalSchemaVersion();
        if (schemaVersion < 4) {
            if (!this.accessModeService.isReadOnlyAccessModeEnabled()) {
                this.runMigration(schemaVersion);
            } else {
                log.warn("Didn't start migration because database access is in readonly mode");
                throw new IllegalStateException("Cannot execute modifying database access in readonly mode.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runMigration(int schemaVersion) {
        log.debug("Preparing Migration Lock");
        ClusterLock lock = this.clusterLockService.getLockForName(EDM_MIGRATION_CLUSTER_LOCK);
        if (lock.tryLock()) {
            try {
                this.logLevelService.setInfoLevel();
                log.info("The schema version of the Easy Dropdown Menu was: " + schemaVersion);
                log.info("Starting migration of Easy Dropdown Menu");
                int updatedSchemaVersion = this.schemaVersionHandler.getAndUpdateSchemaVersion();
                if (updatedSchemaVersion < 4) {
                    this.migrate(updatedSchemaVersion);
                }
                log.warn("The Migration Lock was acquired but another node in the cluster has already migrated. Releasing Easy Dropdown Menu lock");
            }
            catch (Exception e) {
                log.error("There was an exception while trying to migrate the easy dropdown menu", (Throwable)e);
            }
            finally {
                lock.unlock();
                log.debug("EDM Migration Lock released");
                this.logLevelService.resetLogLevel();
            }
        } else {
            throw new MigrationInProgressException("Request failed: A migration is currently in progress.");
        }
    }

    private void migrate(int schemaVersion) {
        if (schemaVersion < 2) {
            this.migrateFromPluginSettings();
        } else if (schemaVersion == 2) {
            this.migrateSetsAndMappingsFromBandana();
        } else if (schemaVersion == 3) {
            this.migrateMappingsFromBandana();
        }
    }

    private void migrateFromPluginSettings() {
        this.steppedMigration(() -> {
            this.statusMigrationTaskInvoker.workGlobal();
            this.textMigrationTaskInvoker.workGlobal();
        }, spaceKey -> {
            this.textMigrationTaskInvoker.workForSpace((String)spaceKey);
            this.statusMigrationTaskInvoker.workForSpace((String)spaceKey);
        }, "'EDM Sets from Plugin Settings Data'");
    }

    private void migrateSetsAndMappingsFromBandana() {
        this.steppedMigration(() -> {
            this.activeObjectsMigrator.migrateGlobalSets();
            this.version1MappingsMigrator.migrateGlobal();
        }, spaceKey -> {
            this.activeObjectsMigrator.migrateSetsForSpace((String)spaceKey);
            this.version1MappingsMigrator.migrateSpace((String)spaceKey);
        }, "EDM  Sets and Mappings from Bandana Store");
    }

    private void migrateMappingsFromBandana() {
        this.steppedMigration(this.version1MappingsMigrator::migrateGlobal, this.version1MappingsMigrator::migrateSpace, "EDM Mappings from Bandana Store");
    }

    private void steppedMigration(Runnable globalMigration, Consumer<String> spaceMigration, String migrationType) {
        log.info("Migrating " + migrationType);
        for (String spaceKey : this.spaceManager.getAllSpaceKeys(SpaceStatus.CURRENT)) {
            try {
                this.transactionTemplate.execute(() -> {
                    spaceMigration.accept(spaceKey);
                    return null;
                });
            }
            catch (Exception e) {
                log.error("Error migrating " + migrationType + "on space: " + spaceKey, (Throwable)e);
            }
        }
        this.transactionTemplate.execute(() -> {
            globalMigration.run();
            this.updateSchemaVersion();
            return null;
        });
    }

    private void updateSchemaVersion() {
        this.schemaVersionHandler.saveGlobalSchemaVersion(4);
    }
}

