/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.edm.persistence;

import com.atlassian.activeobjects.external.ActiveObjects;
import eps.focuspro.DropdownSet.Options.TextOption;
import eps.focuspro.edm.persistence.entities.SetHistoryEntity;
import eps.focuspro.history.historyObjects.OptionHistoryChange;
import eps.focuspro.history.historyObjects.SetHistory;
import java.util.List;
import java.util.stream.Collectors;
import net.java.ao.DBParam;

public class HistoryTextEntityConverter {
    public SetHistory<TextOption> convertFromEntity(List<SetHistoryEntity> setHistoryEntityList, String setId) {
        return new SetHistory<TextOption>(setId, this.convertOptionHistoryChanges(setHistoryEntityList));
    }

    public void convertToEntity(SetHistory<TextOption> setHistory, ActiveObjects ao) {
        for (OptionHistoryChange<TextOption> change : setHistory.getHistoryList()) {
            TextOption oldOption = change.getOldOption();
            TextOption newOption = change.getNewOption();
            SetHistoryEntity entity = (SetHistoryEntity)ao.create(SetHistoryEntity.class, new DBParam[0]);
            entity.setSetId(setHistory.getSetId());
            entity.setOptionId(oldOption.getId());
            entity.setOldOptionName(oldOption.getName());
            entity.setOldColor("");
            entity.setOldSubtle(false);
            entity.setNewOptionName(newOption.getName());
            entity.setNewColor("");
            entity.setNewSubtle(false);
            entity.setDateTime(change.getDateTime());
            entity.setUsername(change.getUserName());
            entity.setHistoryEvent(change.getEvent());
            entity.save();
        }
    }

    private List<OptionHistoryChange<TextOption>> convertOptionHistoryChanges(List<SetHistoryEntity> setHistoryEntities) {
        return setHistoryEntities.stream().map(entity -> new OptionHistoryChange<TextOption>(this.getOldOption((SetHistoryEntity)entity), this.getNewOption((SetHistoryEntity)entity), entity.getDateTime(), entity.getUsername(), entity.getHistoryEvent())).collect(Collectors.toList());
    }

    private TextOption getOldOption(SetHistoryEntity entity) {
        return new TextOption(entity.getOptionId(), entity.getOldOptionName());
    }

    private TextOption getNewOption(SetHistoryEntity entity) {
        return new TextOption(entity.getOptionId(), entity.getNewOptionName());
    }
}

