/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.cql;

import com.atlassian.confluence.xhtml.api.MacroDefinition;
import eps.focuspro.cql.MacroValuesProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class TextExtractor {
    private final MacroValuesProvider macroValuesProvider;

    public TextExtractor(MacroValuesProvider macroValuesProvider) {
        this.macroValuesProvider = macroValuesProvider;
    }

    public StringBuilder getExtractTextStringBuilder(MacroDefinition macro) {
        StringBuilder stringBuilder = new StringBuilder();
        List<String> currentOptions = this.getCurrentOptionValueOfMacro(macro);
        for (String currentOption : currentOptions) {
            stringBuilder.append(" ").append(currentOption);
        }
        return stringBuilder;
    }

    private List<String> getCurrentOptionValueOfMacro(MacroDefinition macro) {
        ArrayList<String> currentOptionList = new ArrayList<String>();
        String macroName = macro.getName();
        Map parameters = macro.getParameters();
        if (StringUtils.isNotBlank((String)macroName)) {
            switch (macroName) {
                case "easy-dropdown-menu": {
                    currentOptionList.addAll(this.macroValuesProvider.getCurrentOptionListFromNonPredefinedMacro(parameters));
                    break;
                }
                case "easy-dropdown-menu-predefined": {
                    currentOptionList.addAll(this.getStandardTextOptionValues(parameters));
                    break;
                }
                case "easy-dropdown-menu-edit-mode": {
                    currentOptionList.addAll(this.getStandardTextOptionValues(parameters));
                    break;
                }
                case "easy-dropdown-menu-status": {
                    currentOptionList.addAll(this.getStatusOptionValuesAsList(parameters));
                    break;
                }
            }
        }
        return currentOptionList;
    }

    private List<String> getStandardTextOptionValues(Map<String, String> parameters) {
        String setId = this.macroValuesProvider.getUniversalSetId(parameters);
        List<String> currentOptionIds = this.macroValuesProvider.getCurrentOptionIdsFromText(parameters);
        return this.macroValuesProvider.getCurrentOptionListFromTextMacro(setId, currentOptionIds);
    }

    private List<String> getStatusOptionValuesAsList(Map<String, String> parameters) {
        String currentOptionId;
        ArrayList<String> statusOptions = new ArrayList<String>();
        String setId = this.macroValuesProvider.getUniversalSetId(parameters);
        String currentOptionValue = this.macroValuesProvider.getCurrentOptionFromStatusMacro(setId, currentOptionId = this.macroValuesProvider.getCurrentOptionIdFromStatus(parameters));
        if (StringUtils.isNotBlank((String)currentOptionValue)) {
            statusOptions.add(currentOptionValue);
        }
        return statusOptions;
    }
}

