/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.configui.spaceconfig;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.spaces.actions.SpaceAdminAction;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import eps.focuspro.DropdownSet.DropdownSet;
import eps.focuspro.DropdownSet.Options.LozengeOption;
import eps.focuspro.DropdownSet.Options.TextOption;
import eps.focuspro.edm.persistence.MigratorGeneral;
import eps.focuspro.edm.persistence.SetEntityAccessor;
import eps.focuspro.edm.persistence.config.EdmSettingsManager;
import eps.focuspro.edm.persistence.config.EdmSpaceSettings;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

@ReadOnlyAccessAllowed
public class SpaceConfigAction
extends SpaceAdminAction {
    private final transient SoyTemplateRenderer soyRenderer;
    private transient List<DropdownSet<LozengeOption>> lozengeSets;
    private List<String> groups;
    private transient List<DropdownSet<TextOption>> textSets;
    private List<String> cssClasses;
    private final transient SetEntityAccessor setEntityAccessor;
    private transient EdmSettingsManager edmSettingsManager;
    private final MigratorGeneral migratorGeneral;
    private final AccessModeService accessModeService;
    private boolean isReadOnlyModeActive;

    public SpaceConfigAction(SoyTemplateRenderer soyTemplateRenderer, SetEntityAccessor setEntityAccessor, EdmSettingsManager edmSettingsManager, MigratorGeneral migratorGeneral, AccessModeService accessModeService) {
        this.soyRenderer = soyTemplateRenderer;
        this.setEntityAccessor = setEntityAccessor;
        this.edmSettingsManager = edmSettingsManager;
        this.migratorGeneral = migratorGeneral;
        this.accessModeService = accessModeService;
    }

    public String execute() {
        this.migratorGeneral.check();
        HttpServletRequest request = this.getCurrentRequest();
        String spaceKey = request.getParameter("key") == null ? "none" : request.getParameter("key");
        EdmSpaceSettings spaceSettings = this.edmSettingsManager.getSpaceSettings(spaceKey);
        this.cssClasses = spaceSettings.getCssClasses();
        this.lozengeSets = this.setEntityAccessor.getLozengeSetsSpaceOrGlobal(spaceKey) == null ? new ArrayList() : this.setEntityAccessor.getLozengeSetsSpaceOrGlobal(spaceKey);
        this.groups = spaceSettings.getPermittedGroups();
        this.textSets = this.setEntityAccessor.getLozengeSetsSpaceOrGlobal(spaceKey) == null ? new ArrayList() : this.setEntityAccessor.getTextSetsSpaceOrGlobal(spaceKey);
        this.isReadOnlyModeActive = this.accessModeService.isReadOnlyAccessModeEnabled();
        return "input";
    }

    public String doDefault() {
        return "input";
    }

    public List<DropdownSet<LozengeOption>> getLozengeSets() {
        return this.lozengeSets;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public List<DropdownSet<TextOption>> getTextSets() {
        return this.textSets;
    }

    public SoyTemplateRenderer getSoyRenderer() {
        return this.soyRenderer;
    }

    public List<String> getCssClasses() {
        return this.cssClasses;
    }

    public boolean getIsReadOnlyModeActive() {
        return this.isReadOnlyModeActive;
    }
}

