/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.configui.helper;

import com.atlassian.confluence.web.UrlBuilder;
import eps.focuspro.configui.LozengeType;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class ImagePlaceholderHelper {
    public static String createUrlSingleMultiPlaceholder(String textToDisplay, int imageWidth, boolean isStateMessage, boolean isMultiSelect) {
        UrlBuilder urlBuilder = isMultiSelect ? new UrlBuilder("/plugins/servlet/eps-easydropdownmenu/multiselect/placeholder") : new UrlBuilder("/plugins/servlet/eps-easydropdownmenu/singleselect/placeholder");
        urlBuilder.add("text", textToDisplay);
        urlBuilder.add("length", imageWidth);
        urlBuilder.add("isStateMessage", isStateMessage);
        return urlBuilder.toUrl();
    }

    public static void setBackground(int imageWidth, int imageHeight, Color color, BufferedImage image, Graphics2D graphics2D, LozengeType lozengeType) {
        graphics2D.setColor(color);
        graphics2D.fillRect(0, 0, imageWidth, imageHeight);
        ImagePlaceholderHelper.roundCorners(imageWidth, imageHeight, image);
        if (lozengeType.equals((Object)LozengeType.SUBTLE)) {
            ImagePlaceholderHelper.adjustForSubtle(imageWidth, imageHeight, graphics2D);
        }
    }

    public static void drawText(Graphics2D graphics2D, String text, Font font, Color fontColor, int x, int y) {
        graphics2D.setFont(font);
        graphics2D.setColor(fontColor);
        graphics2D.drawString(text, x, y);
    }

    private static void roundCorners(int imageWidth, int imageHeight, BufferedImage image) {
        int rbgWhite = Color.WHITE.getRGB();
        image.setRGB(0, 0, rbgWhite);
        image.setRGB(imageWidth - 1, 0, rbgWhite);
        image.setRGB(imageWidth - 1, imageHeight - 1, rbgWhite);
        image.setRGB(0, imageHeight - 1, rbgWhite);
    }

    private static void adjustForSubtle(int imageWidth, int imageHeight, Graphics2D graphics2D) {
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(2, 2, imageWidth - 4, imageHeight - 4);
    }
}

