/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.configui;

import eps.focuspro.configui.LozengeType;
import eps.focuspro.configui.helper.ImagePlaceholderHelper;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImagePlaceholderMultiGenerator
extends HttpServlet {
    private static final int imageHeight = 31;
    private static final Color REQUEST_GREY = new Color(204, 204, 204);
    private static final Color REQUEST_LIGHT_GREY = new Color(223, 225, 230);
    private static final Color REQUEST_DARK_GREY = new Color(100, 100, 100);
    private static final Color TEXT_COLOR = new Color(23, 43, 77);
    private static final Stroke bold = new BasicStroke(2.0f);
    private static final Logger log = LoggerFactory.getLogger(ImagePlaceholderMultiGenerator.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String text = req.getParameter("text");
        String[] options = text.equals("") ? new String[]{} : text.split("///");
        int imageWidth = Integer.parseInt(req.getParameter("length"));
        BufferedImage image = new BufferedImage(imageWidth, 31, 1);
        Graphics2D graphics2D = image.createGraphics();
        ImagePlaceholderHelper.setBackground(imageWidth, 31, Color.WHITE, image, graphics2D, LozengeType.STANDARD);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.drawOuterBox(imageWidth, graphics2D);
        this.drawSelectedOptions(options, graphics2D);
        resp.setContentType("image/png");
        try {
            ImageIO.write((RenderedImage)image, "png", (OutputStream)resp.getOutputStream());
        }
        catch (Exception e) {
            log.error("Error on EditorPlaceholder", (Throwable)e);
        }
    }

    private void drawOuterBox(int imageWidth, Graphics2D graphics2D) {
        graphics2D.setColor(REQUEST_GREY);
        graphics2D.drawRoundRect(0, 0, imageWidth - 1, 30, 8, 8);
    }

    private void drawSelectedOptions(String[] options, Graphics2D graphics2D) {
        int startPosition = 4;
        Stroke normal = graphics2D.getStroke();
        for (String option : options) {
            this.drawOptionBox(startPosition, graphics2D, option);
            this.drawOptionText(startPosition, graphics2D, option);
            this.drawOptionCross(startPosition, graphics2D, normal, option);
            startPosition += graphics2D.getFontMetrics().stringWidth(option) + 28;
        }
    }

    private void drawOptionBox(int startPosition, Graphics2D graphics2D, String option) {
        graphics2D.setColor(REQUEST_LIGHT_GREY);
        graphics2D.drawRoundRect(startPosition, 5, graphics2D.getFontMetrics().stringWidth(option) + 22, 20, 5, 5);
    }

    private void drawOptionText(int startPosition, Graphics2D graphics2D, String option) {
        ImagePlaceholderHelper.drawText(graphics2D, option, graphics2D.getFont(), TEXT_COLOR, startPosition + 5, 20);
    }

    private void drawOptionCross(int startPosition, Graphics2D graphics2D, Stroke normal, String option) {
        graphics2D.setColor(REQUEST_DARK_GREY);
        graphics2D.setStroke(bold);
        graphics2D.drawLine(startPosition + graphics2D.getFontMetrics().stringWidth(option) + 11, 14, startPosition + graphics2D.getFontMetrics().stringWidth(option) + 16, 19);
        graphics2D.drawLine(startPosition + graphics2D.getFontMetrics().stringWidth(option) + 11, 19, startPosition + graphics2D.getFontMetrics().stringWidth(option) + 16, 14);
        graphics2D.setStroke(normal);
    }
}

