/*
 * Decompiled with CFR 0.152.
 */
package de.xalt.confluence.plugins.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.Format;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.RequiresFormat;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;

public class AdvancedTabs
extends BaseMacro
implements Macro {
    private static final String DEFAULT_TAB_DISPLAY = "horizontal";
    private static final String DEFAULT_VALUE_TAB_WIDTH = "100%";
    @ComponentImport
    private final PluginLicenseManager pluginLicenseManager;

    @Inject
    public AdvancedTabs(PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    @RequiresFormat(value=Format.View)
    public String execute(Map<String, String> params, String body, ConversionContext conversionContext) throws MacroExecutionException {
        Map contextMap = MacroUtils.defaultVelocityContext();
        String tabsName = params.get("tabsName");
        String tabDisplay = params.get("tabDisplay");
        String tabContentWidth = params.get("tabContentWidth");
        if (StringUtils.isEmpty((CharSequence)tabDisplay)) {
            tabDisplay = DEFAULT_TAB_DISPLAY;
        }
        if (StringUtils.isEmpty((CharSequence)tabContentWidth)) {
            tabContentWidth = DEFAULT_VALUE_TAB_WIDTH;
        }
        contextMap.put("isLicenseOk", this.isLicenseOk());
        contextMap.put("tabsName", tabsName);
        contextMap.put("tabDisplay", tabDisplay);
        contextMap.put("tabContentWidth", tabContentWidth);
        contextMap.put("body", body);
        return VelocityUtils.getRenderedTemplate((String)"advanced-tab-view.vm", (Map)contextMap);
    }

    private boolean isLicenseOk() {
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            PluginLicense pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            return !pluginLicense.getError().isDefined();
        }
        return false;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return null;
    }

    public String execute(Map map, String s, RenderContext renderContext) throws MacroException {
        return null;
    }
}

