(function (AJS, $) {
  'use strict';

  XALT.AdvancedTabs.View = function (containerIndex, $container) {
    var $tabsMenu = $container.find('.tabs-menu');
    var $tabs = $container.find('.tab-container');

    applySettings($container);

    $tabs.each(function (tabIndex) {
      var tabName = $(this).data('tab-name');
      var tabId = 'tab-' + containerIndex + '-' + $(this).data('tab-id') + '-' + tabIndex;
      var tabClass = 'menu-item';

      // set active tab
      if (tabIndex === 0) {
        tabClass = tabClass + ' ' + 'active-tab';
        $(this).addClass('active-pane');
      }

      $(this).attr('id', tabId);

      $tabsMenu.append('<li class="' + tabClass + '">' +
        '<a href="#' + tabId + '" class="advanced-tabs-links">' + tabName + '</a>' +
        '</li>');
    });

    // override tab click link to prevent jumping to anchor
    $tabsMenu.on('click', '.advanced-tabs-links', function () {
      return false;
    });

    function applySettings($container) {
      var $tabContentWidth = $container.find('#tabContentWidth');
      // get and apply the width
      if ($tabContentWidth.val()) {
        $tabs.css('width', $tabContentWidth.val());
      }
    }
  };
})(AJS, AJS.$);
