/*
 * Decompiled with CFR 0.152.
 */
package de.xalt.confluence.plugins.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.Format;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.RequiresFormat;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;

public class Tab
extends BaseMacro
implements Macro {
    @RequiresFormat(value=Format.View)
    public String execute(Map<String, String> params, String body, ConversionContext conversionContext) throws MacroExecutionException {
        Map contextMap = MacroUtils.defaultVelocityContext();
        String tabName = params.get("tabName");
        String tabId = this.generateTabId(tabName);
        contextMap.put("tabName", tabName);
        contextMap.put("tabId", tabId);
        contextMap.put("body", body);
        return VelocityUtils.getRenderedTemplate((String)"tab-view.vm", (Map)contextMap);
    }

    private String generateTabId(String tabName) {
        String tabId = Integer.toString(tabName.hashCode());
        return StringEscapeUtils.escapeHtml((String)tabId);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return null;
    }

    public String execute(Map map, String s, RenderContext renderContext) throws MacroException {
        return null;
    }
}

