/*
 * Decompiled with CFR 0.152.
 */
package de.xalt.confluence.plugins.util;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.twelvemonkeys.contrib.tiff.TIFFUtilities;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageRotator {
    private static final Logger log = LoggerFactory.getLogger(ImageRotator.class);

    public static int getOrientation(InputStream metaDataInputStream) {
        try {
            Metadata metadata = ImageMetadataReader.readMetadata(metaDataInputStream);
            ExifIFD0Directory directory = metadata.getFirstDirectoryOfType(ExifIFD0Directory.class);
            int orientation = 1;
            if (directory != null) {
                try {
                    orientation = directory.getInt(274);
                }
                catch (MetadataException me) {
                    log.warn("Could not get orientation");
                    return -1;
                }
                return orientation;
            }
            return -1;
        }
        catch (ImageProcessingException | IOException e) {
            return -1;
        }
    }

    public static BufferedImage imageRotateBasedOnOrientation(int orientation, BufferedImage image) {
        return TIFFUtilities.applyOrientation(image, orientation);
    }
}

