/*
 * Decompiled with CFR 0.152.
 */
package de.xalt.confluence.plugins.resources;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.languages.LanguageManager;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.thumbnail.ThumbnailManager;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import de.xalt.confluence.plugins.model.Gallery;
import de.xalt.confluence.plugins.repository.PictureRepository;
import de.xalt.confluence.plugins.service.GalleryService;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;

@Path(value="/xalt-gallery-macro")
public class XaltGalleryMacro {
    @ComponentImport
    private PluginLicenseManager pluginLicenseManager;
    @ComponentImport
    private final PluginSettingsFactory pluginSettingsFactory;
    private final LanguageManager languageManager;
    private GalleryService galleryService;
    private PictureRepository pictureRepository;
    private BootstrapManager bootstrapManager;
    private AttachmentManager attachmentManager;
    private ThumbnailManager thumbnailManager;
    private ConfluenceActionSupport confluenceActionSupport;
    private final ContentEntityManager contentEntityManager;

    @Inject
    public XaltGalleryMacro(GalleryService galleryService, PluginLicenseManager pluginLicenseManager, PluginSettingsFactory pluginSettingsFactory, @ComponentImport @Named(value="contentEntityManager") ContentEntityManager contentEntityManager) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.galleryService = galleryService;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.contentEntityManager = contentEntityManager;
        this.languageManager = (LanguageManager)ContainerManager.getComponent((String)"languageManager");
    }

    private boolean isLicenseOk() {
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            PluginLicense pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            return !pluginLicense.getError().isDefined();
        }
        return false;
    }

    @GET
    @Path(value="/getmacro")
    @Produces(value={"text/html"})
    public Response getMacro(@QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="pageId") Long pageId, @QueryParam(value="galleryName") String galleryName, @QueryParam(value="galleryType") String galleryType) throws Exception {
        PluginSettings pluginSettings;
        String referenceMessage;
        ContentEntityObject ceo;
        Long galleryPageId;
        String confluenceBandanaContext = "de.xalt.confluence.plugins.advanced-gallery-macro.xalt-gallery";
        Map context = MacroUtils.defaultVelocityContext();
        Gallery gallery = null;
        if (StringUtils.isNotBlank((CharSequence)galleryName)) {
            gallery = this.galleryService.getGallery(confluenceBandanaContext, galleryName);
        }
        boolean isGalleryPageIdExists = gallery != null && gallery.getPageId() != null;
        Long l = galleryPageId = isGalleryPageIdExists ? Long.valueOf(gallery.getPageId()) : pageId;
        if (galleryPageId != null && (ceo = this.contentEntityManager.getById(galleryPageId.longValue())) != null && !ceo.isDeleted()) {
            context.put("galleryPostUrl", ceo.getUrlPath());
        }
        if (StringUtils.isNotEmpty((CharSequence)(referenceMessage = (String)(pluginSettings = this.pluginSettingsFactory.createGlobalSettings()).get("xalt.advanced-image-gallery.reference-config.reference-message")))) {
            referenceMessage = referenceMessage.replace("\n", "<br/>");
            if (StringUtils.isNotEmpty((CharSequence)(referenceMessage = Jsoup.clean((String)referenceMessage, (Safelist)Safelist.basic())))) {
                context.put("referenceMessageHtml", referenceMessage);
            }
        }
        String displayType = "slideshow";
        context.put("isLicenseOk", this.isLicenseOk());
        context.put("displayType", displayType);
        context.put("edit", true);
        context.put("gallery", gallery);
        context.put("galleryType", galleryType);
        return Response.ok((Object)VelocityUtils.getRenderedTemplate((String)"xalt-gallery-macro.vm", (Map)context)).build();
    }

    private String getLocale() {
        String defaultLanguage = this.languageManager.getGlobalDefaultLanguage().getLanguage();
        String defaultCountry = this.languageManager.getGlobalDefaultLanguage().getCountry();
        String locale = defaultLanguage + "_" + defaultCountry;
        return locale;
    }

    public void setConfluenceActionSupport(ConfluenceActionSupport confluenceActionSupport) {
        this.confluenceActionSupport = confluenceActionSupport;
    }

    public void setPictureRepository(PictureRepository pictureRepository) {
        this.pictureRepository = pictureRepository;
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public void setThumbnailManager(ThumbnailManager thumbnailManager) {
        this.thumbnailManager = thumbnailManager;
    }
}

