/*
 * Decompiled with CFR 0.152.
 */
package de.xalt.confluence.plugins.api;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.util.longrunning.ConfluenceAbstractLongRunningTask;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import de.xalt.confluence.plugins.model.Gallery;
import de.xalt.confluence.plugins.model.GallerySettings;
import de.xalt.confluence.plugins.model.Picture;
import de.xalt.confluence.plugins.service.GalleryService;
import de.xalt.confluence.plugins.transaction.ScaleImageTransaction;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GalleryScaleLongRunningTask
extends ConfluenceAbstractLongRunningTask {
    private static final Logger log = LoggerFactory.getLogger(GalleryScaleLongRunningTask.class);
    private final TransactionTemplate transactionTemplate;
    private final GalleryService galleryService;
    private final ScaleImageTransaction scaleImageTransaction;
    private final String galleryName;
    private ContentEntityObject ceo;
    private boolean isGalleryConfiguredAvailable = false;
    private Gallery configuredGallery;
    private GallerySettings configuredGallerySettings;

    public GalleryScaleLongRunningTask(TransactionTemplate transactionTemplate, GalleryService galleryService, ScaleImageTransaction scaleImageTransaction, String galleryName) {
        this.transactionTemplate = transactionTemplate;
        this.galleryService = galleryService;
        this.scaleImageTransaction = scaleImageTransaction;
        this.galleryName = galleryName;
    }

    public GalleryScaleLongRunningTask(TransactionTemplate transactionTemplate, GalleryService galleryService, ScaleImageTransaction scaleImageTransaction, String galleryName, ContentEntityObject ceo, Gallery configuredGallery, GallerySettings configuredGallerySettings) {
        this.isGalleryConfiguredAvailable = true;
        this.transactionTemplate = transactionTemplate;
        this.galleryService = galleryService;
        this.scaleImageTransaction = scaleImageTransaction;
        this.galleryName = galleryName;
        this.ceo = ceo;
        this.configuredGallery = configuredGallery;
        this.configuredGallerySettings = configuredGallerySettings;
    }

    protected void runInternal() {
        GallerySettings settings;
        Gallery gallery;
        log.debug("Running task: " + this.getName());
        if (this.isGalleryConfiguredAvailable) {
            gallery = this.configuredGallery;
            settings = this.configuredGallerySettings;
        } else {
            gallery = this.galleryService.getGallery("de.xalt.confluence.plugins.advanced-gallery-macro.xalt-gallery", this.galleryName);
            settings = this.galleryService.getGallerySettings(this.galleryName);
        }
        boolean isImagesScaled = false;
        if (gallery == null) {
            log.debug("Gallery scale long running task failed. Gallery:" + this.galleryName + " does not exists");
            return;
        }
        settings.setScalingImages(true);
        this.updateGalleryWithSetting(gallery, settings);
        List<Picture> pictureList = gallery.getPictures();
        try {
            for (Picture picture : pictureList) {
                this.transactionTemplate.execute(() -> {
                    if (this.ceo != null) {
                        log.debug("Content Entity Provided. Scaling image with Content Entity for image" + picture.getFileName());
                        return this.scaleImageTransaction.scaleGalleryTransaction(picture, gallery, pictureList, null, this.ceo);
                    }
                    return this.scaleImageTransaction.scaleGalleryTransaction(picture, gallery, pictureList, null);
                });
            }
            isImagesScaled = true;
        }
        catch (Exception e) {
            log.error("Content Entity update Interrupted. Will stop current scaling progress." + this.galleryName, (Throwable)e);
            settings.setImagesScaled(false);
        }
        log.info("Saving new settings");
        settings.setScalingImages(false);
        settings.setImagesScaled(isImagesScaled);
        this.updateGalleryWithSetting(gallery, settings);
    }

    private void updateGalleryWithSetting(Gallery gallery, GallerySettings settings) {
        try {
            this.galleryService.updateGalleryWithSetting(gallery, settings, "de.xalt.confluence.plugins.advanced-gallery-macro.xalt-gallery", this.galleryName);
        }
        catch (Exception e) {
            log.debug("Gallery unable to save settings for Gallery: " + this.galleryName, (Throwable)e);
        }
    }

    public String getName() {
        return "Gallery scale long running task";
    }
}

