/*
 * Decompiled with CFR 0.152.
 */
package de.xalt.confluence.plugins.api;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.util.longrunning.ConfluenceAbstractLongRunningTask;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.scheduler.JobRunnerResponse;
import de.xalt.confluence.plugins.model.Gallery;
import de.xalt.confluence.plugins.model.Picture;
import de.xalt.confluence.plugins.service.GalleryService;
import de.xalt.confluence.plugins.transaction.ScaleImageTransaction;
import de.xalt.confluence.plugins.util.ImageScalerHelper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GalleryImageScaleLongRunningTask
extends ConfluenceAbstractLongRunningTask {
    private static final Logger log = LoggerFactory.getLogger(GalleryImageScaleLongRunningTask.class);
    private final PageManager pageManager;
    private final TransactionTemplate transactionTemplate;
    private final ImageScalerHelper imageScalerHelper;
    private final GalleryService galleryService;
    private final ScaleImageTransaction scaleImageTransaction;
    private final Long pageID;
    private final String galleryName;
    private final String imageFileName;

    public GalleryImageScaleLongRunningTask(PageManager pageManager, TransactionTemplate transactionTemplate, ImageScalerHelper imageScalerHelper, GalleryService galleryService, ScaleImageTransaction scaleImageTransaction, Long pageID, String galleryName, String imageFilename) {
        this.pageManager = pageManager;
        this.transactionTemplate = transactionTemplate;
        this.imageScalerHelper = imageScalerHelper;
        this.galleryService = galleryService;
        this.scaleImageTransaction = scaleImageTransaction;
        this.pageID = pageID;
        this.galleryName = galleryName;
        this.imageFileName = imageFilename;
    }

    protected void runInternal() {
        log.debug("Running task: " + this.getName());
        Attachment image = this.imageScalerHelper.getImage(this.imageFileName, (ContentEntityObject)this.pageManager.getAbstractPage(this.pageID.longValue()));
        Gallery gallery = this.galleryService.getGallery("de.xalt.confluence.plugins.advanced-gallery-macro.xalt-gallery", this.galleryName);
        if (image == null || gallery == null) {
            JobRunnerResponse.aborted((String)("Gallery Image Scale Job Failed. Gallery:" + this.galleryName + " does not exists."));
        }
        List<Picture> pictureList = gallery.getPictures();
        for (Picture picture : pictureList) {
            if (!picture.getFileName().equals(this.imageFileName)) continue;
            this.transactionTemplate.execute(() -> this.scaleImageTransaction.scaleImageTransaction(gallery, pictureList, picture, image));
        }
    }

    public String getName() {
        return "Gallery image scale long running task";
    }
}

