/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.contrib.tiff;

import com.twelvemonkeys.image.AffineTransformOp;
import com.twelvemonkeys.imageio.metadata.AbstractDirectory;
import com.twelvemonkeys.imageio.metadata.CompoundDirectory;
import com.twelvemonkeys.imageio.metadata.Directory;
import com.twelvemonkeys.imageio.metadata.Entry;
import com.twelvemonkeys.imageio.metadata.tiff.IFD;
import com.twelvemonkeys.imageio.metadata.tiff.TIFFEntry;
import com.twelvemonkeys.imageio.metadata.tiff.TIFFReader;
import com.twelvemonkeys.imageio.metadata.tiff.TIFFWriter;
import com.twelvemonkeys.lang.Validate;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public final class TIFFUtilities {
    private TIFFUtilities() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void merge(List<File> list, File file) throws IOException {
        ImageOutputStream imageOutputStream = null;
        try {
            imageOutputStream = ImageIO.createImageOutputStream(file);
            for (File file2 : list) {
                ImageInputStream imageInputStream = null;
                try {
                    imageInputStream = ImageIO.createImageInputStream(file2);
                    List<TIFFPage> list2 = TIFFUtilities.getPages(imageInputStream);
                    TIFFUtilities.writePages(imageOutputStream, list2);
                }
                finally {
                    if (imageInputStream == null) continue;
                    imageInputStream.close();
                }
            }
        }
        finally {
            if (imageOutputStream != null) {
                imageOutputStream.flush();
                imageOutputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> split(File file, File file2) throws IOException {
        ArrayList<File> arrayList = new ArrayList<File>();
        try (ImageInputStream imageInputStream = null;){
            imageInputStream = ImageIO.createImageInputStream(file);
            List<TIFFPage> list = TIFFUtilities.getPages(imageInputStream);
            int n = 1;
            for (TIFFPage tIFFPage : list) {
                ArrayList<TIFFPage> arrayList2 = new ArrayList<TIFFPage>(1);
                ImageInputStream imageInputStream2 = null;
                try {
                    File file3 = new File(file2, String.format("%04d", n) + ".tif");
                    imageInputStream2 = ImageIO.createImageOutputStream(file3);
                    arrayList2.clear();
                    arrayList2.add(tIFFPage);
                    TIFFUtilities.writePages((ImageOutputStream)imageInputStream2, arrayList2);
                    arrayList.add(file3);
                }
                finally {
                    if (imageInputStream2 != null) {
                        imageInputStream2.flush();
                        imageInputStream2.close();
                    }
                }
                ++n;
            }
        }
        return arrayList;
    }

    public static void rotatePages(ImageInputStream imageInputStream, ImageOutputStream imageOutputStream, int n) throws IOException {
        TIFFUtilities.rotatePage(imageInputStream, imageOutputStream, n, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rotatePage(ImageInputStream imageInputStream, ImageOutputStream imageOutputStream, int n, int n2) throws IOException {
        try (ImageInputStream imageInputStream2 = null;){
            List<TIFFPage> list = TIFFUtilities.getPages(imageInputStream);
            if (n2 != -1) {
                list.get(n2).rotate(n);
            } else {
                for (TIFFPage tIFFPage : list) {
                    tIFFPage.rotate(n);
                }
            }
            TIFFUtilities.writePages(imageOutputStream, list);
        }
    }

    public static List<TIFFPage> getPages(ImageInputStream imageInputStream) throws IOException {
        CompoundDirectory compoundDirectory = (CompoundDirectory)new TIFFReader().read(imageInputStream);
        int n = compoundDirectory.directoryCount();
        ArrayList<TIFFPage> arrayList = new ArrayList<TIFFPage>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(new TIFFPage(compoundDirectory.getDirectory(i), imageInputStream));
        }
        return arrayList;
    }

    public static void writePages(ImageOutputStream imageOutputStream, List<TIFFPage> list) throws IOException {
        TIFFWriter tIFFWriter = new TIFFWriter();
        long l = imageOutputStream.getStreamPosition();
        if (l == 0L) {
            tIFFWriter.writeTIFFHeader(imageOutputStream);
            l = imageOutputStream.getStreamPosition();
            imageOutputStream.writeInt(0);
        } else {
            l -= 4L;
        }
        for (TIFFPage tIFFPage : list) {
            long l2 = tIFFPage.write(imageOutputStream, tIFFWriter);
            long l3 = imageOutputStream.getStreamPosition();
            imageOutputStream.seek(l);
            imageOutputStream.writeInt((int)l2);
            imageOutputStream.seek(l3);
            l = l3;
            imageOutputStream.writeInt(0);
        }
    }

    public static BufferedImage applyOrientation(BufferedImage bufferedImage, int n) {
        int n2;
        int n3;
        boolean bl = false;
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight();
        double d = (double)n4 / 2.0;
        double d2 = (double)n5 / 2.0;
        AffineTransform affineTransform = new AffineTransform();
        switch (n) {
            case 1: {
                return bufferedImage;
            }
            case 2: {
                affineTransform.translate(d, d2);
                affineTransform.scale(-1.0, 1.0);
                affineTransform.translate(-d, -d2);
                break;
            }
            case 3: {
                affineTransform.quadrantRotate(2, d, d2);
                break;
            }
            case 4: {
                affineTransform.translate(d, d2);
                affineTransform.scale(1.0, -1.0);
                affineTransform.translate(-d, -d2);
                break;
            }
            case 5: {
                affineTransform.translate(d, d2);
                affineTransform.scale(-1.0, 1.0);
                affineTransform.quadrantRotate(1);
                affineTransform.translate(-d, -d2);
                bl = true;
                break;
            }
            case 6: {
                affineTransform.quadrantRotate(1, d, d2);
                bl = true;
                break;
            }
            case 7: {
                affineTransform.translate(d, d2);
                affineTransform.scale(1.0, -1.0);
                affineTransform.quadrantRotate(1);
                affineTransform.translate(-d, -d2);
                bl = true;
                break;
            }
            case 8: {
                affineTransform.quadrantRotate(3, d, d2);
                bl = true;
            }
        }
        if (bl) {
            n3 = n5;
            n2 = n4;
        } else {
            n3 = n4;
            n2 = n5;
        }
        AffineTransform affineTransform2 = AffineTransform.getTranslateInstance((double)(n3 - n4) / 2.0, (double)(n2 - n5) / 2.0);
        affineTransform2.concatenate(affineTransform);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform2, null);
        return affineTransformOp.filter(bufferedImage, null);
    }

    public static interface TIFFBaseline {
        public static final int ORIENTATION_TOPLEFT = 1;
    }

    public static interface TIFFExtension {
        public static final int ORIENTATION_TOPRIGHT = 2;
        public static final int ORIENTATION_BOTRIGHT = 3;
        public static final int ORIENTATION_BOTLEFT = 4;
        public static final int ORIENTATION_LEFTTOP = 5;
        public static final int ORIENTATION_RIGHTTOP = 6;
        public static final int ORIENTATION_RIGHTBOT = 7;
        public static final int ORIENTATION_LEFTBOT = 8;
        public static final int COMPRESSION_OLD_JPEG = 6;
        public static final int COMPRESSION_JPEG = 7;
    }

    public static class TIFFPage {
        private Directory IFD;
        private ImageInputStream stream;

        private TIFFPage(Directory directory, ImageInputStream imageInputStream) {
            this.IFD = directory;
            this.stream = imageInputStream;
        }

        private long write(ImageOutputStream imageOutputStream, TIFFWriter tIFFWriter) throws IOException {
            List<Entry> list = this.writeDirectoryData(this.IFD, imageOutputStream);
            return tIFFWriter.writeIFD(list, imageOutputStream);
        }

        private List<Entry> writeDirectoryData(Directory directory, ImageOutputStream imageOutputStream) throws IOException {
            int n;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            ArrayList<Entry> arrayList = new ArrayList<Entry>();
            Iterator iterator = directory.iterator();
            while (iterator.hasNext()) {
                object4 = (Entry)iterator.next();
                if (object4.getValue() instanceof Directory) {
                    object3 = this.writeDirectoryData((Directory)object4.getValue(), imageOutputStream);
                    new TIFFEntry((Integer)object4.getIdentifier(), 13, new AbstractDirectory((Collection)object3){});
                }
                arrayList.add((Entry)object4);
            }
            object4 = new long[]{};
            object3 = new long[]{};
            int[] nArray = new int[]{};
            boolean bl = false;
            Entry entry = directory.getEntryById(273);
            Entry entry2 = directory.getEntryById(279);
            if (entry != null && entry2 != null) {
                object4 = this.getValueAsLongArray(entry);
                object3 = this.getValueAsLongArray(entry2);
            } else {
                entry = directory.getEntryById(324);
                entry2 = directory.getEntryById(325);
                if (entry != null && entry2 != null) {
                    object4 = this.getValueAsLongArray(entry);
                    object3 = this.getValueAsLongArray(entry2);
                    bl = true;
                }
            }
            int n2 = -1;
            Entry entry3 = directory.getEntryById(259);
            if (entry3 != null && entry3.getValue() instanceof Number) {
                n2 = ((Number)entry3.getValue()).shortValue();
            }
            boolean bl2 = false;
            Entry entry4 = directory.getEntryById(513);
            Entry entry5 = directory.getEntryById(514);
            long[] lArray = null;
            long[] lArray2 = null;
            if (entry4 != null && entry4.valueCount() > 0) {
                lArray = new long[]{};
                lArray2 = this.getValueAsLongArray(entry4);
                if (entry5 != null && entry5.valueCount() > 0) {
                    lArray = this.getValueAsLongArray(entry5);
                }
                if (((long[])object4).length == 1 && object4[0] == lArray2[0]) {
                    arrayList.remove(entry4);
                    arrayList.remove(entry5);
                } else if (((long[])object4).length == 1 && entry5 != null && object4[0] == lArray2[0] + lArray[0]) {
                    nArray = this.writeData(lArray2, lArray, imageOutputStream);
                    this.writeData((long[])object4, (long[])object3, imageOutputStream);
                    arrayList.remove(entry);
                    arrayList.add(new TIFFEntry(bl ? 324 : 273, (Object)nArray));
                    arrayList.remove(entry2);
                    arrayList.add(new TIFFEntry(bl ? 325 : 279, (Object)new int[]{(int)(lArray[0] + object3[0])}));
                    arrayList.remove(entry4);
                    arrayList.remove(entry5);
                    bl2 = true;
                } else if (((long[])object4).length == 1 && entry5 != null && lArray2[0] < object4[0] && lArray2[0] + lArray[0] > object4[0] + object3[0]) {
                    nArray = this.writeData(lArray2, lArray, imageOutputStream);
                    arrayList.remove(entry);
                    arrayList.add(new TIFFEntry(bl ? 324 : 273, (Object)nArray));
                    arrayList.remove(entry2);
                    arrayList.add(new TIFFEntry(bl ? 325 : 279, (Object)new int[]{(int)lArray[0]}));
                    arrayList.remove(entry4);
                    arrayList.remove(entry5);
                    bl2 = true;
                } else if (entry5 != null) {
                    arrayList.remove(entry4);
                    arrayList.remove(entry5);
                    this.stream.seek(lArray2[0]);
                    object2 = new byte[(int)lArray[0]];
                    this.stream.readFully((byte[])object2);
                    this.stream.seek(object4[0]);
                    if (this.stream.read() != 255 || this.stream.read() != 218) {
                        throw new IOException("Old-style-JPEG with multiple strips are only supported, if first strip contains SOS");
                    }
                    int n3 = this.stream.read() << 8 | this.stream.read();
                    object = new byte[n3 + 2];
                    object[0] = -1;
                    object[1] = -38;
                    object[2] = (byte)((n3 & 0xFF00) >> 8);
                    object[3] = (byte)(n3 & 0xFF);
                    this.stream.readFully((byte[])object, 4, n3 - 2);
                    nArray = new int[((long[])object4).length];
                    int[] nArray2 = new int[((long[])object3).length];
                    for (n = 0; n < ((long[])object4).length; ++n) {
                        nArray[n] = (int)imageOutputStream.getStreamPosition();
                        imageOutputStream.write((byte[])object2);
                        this.stream.seek(object4[n]);
                        byte[] byArray = new byte[(int)object3[n]];
                        nArray2[n] = (int)((long)((long[])object2).length + object3[n]);
                        this.stream.readFully(byArray);
                        if (byArray[0] != -1 || byArray[1] != -38) {
                            imageOutputStream.write((byte[])object);
                            int n4 = n;
                            nArray2[n4] = nArray2[n4] + ((Object)object).length;
                        }
                        imageOutputStream.write(byArray);
                    }
                    arrayList.remove(entry);
                    arrayList.add(new TIFFEntry(bl ? 324 : 273, (Object)nArray));
                    arrayList.remove(entry2);
                    arrayList.add(new TIFFEntry(bl ? 325 : 279, (Object)nArray2));
                    arrayList.remove(entry4);
                    arrayList.remove(entry5);
                    bl2 = true;
                }
            } else if (n2 == 6) {
                object2 = this.getValueAsLongArray(directory.getEntryById(530));
                int n5 = object2 != null ? (int)((object2[0] & 0xFL) << 4 | object2[1] & 0xFL) : 34;
                int n6 = ((Number)directory.getEntryById(277).getValue()).intValue();
                n = ((Number)directory.getEntryById(256).getValue()).intValue();
                int n7 = ((Number)directory.getEntryById(257).getValue()).intValue();
                int n8 = ((Number)(bl ? directory.getEntryById(323) : directory.getEntryById(278)).getValue()).intValue();
                int n9 = bl ? ((Number)directory.getEntryById(322).getValue()).intValue() : n;
                nArray = new int[((long[])object4).length];
                int[] nArray3 = new int[((long[])object3).length];
                for (int i = 0; i < ((long[])object4).length; ++i) {
                    byte[] byArray = new byte[2];
                    this.stream.seek(object4[i]);
                    this.stream.readFully(byArray);
                    nArray[i] = (int)imageOutputStream.getStreamPosition();
                    if (byArray[0] == -1 && byArray[1] == -40) {
                        this.writeData(this.stream, imageOutputStream, object4[i], object3[i]);
                    } else if (byArray[0] == -1 && byArray[1] == -38) {
                        imageOutputStream.writeShort(65496);
                        this.writeSOF0(imageOutputStream, n6, n9, n8, n5);
                        this.writeData(this.stream, imageOutputStream, object4[i], object3[i]);
                        imageOutputStream.writeShort(65497);
                    } else {
                        imageOutputStream.writeShort(65496);
                        this.writeSOF0(imageOutputStream, n6, n9, n8, n5);
                        this.writeSOS(imageOutputStream, n6);
                        this.writeData(this.stream, imageOutputStream, object4[i], object3[i]);
                        imageOutputStream.writeShort(65497);
                    }
                    nArray3[i] = (int)imageOutputStream.getStreamPosition() - nArray[i];
                }
                arrayList.remove(entry);
                arrayList.add(new TIFFEntry(bl ? 324 : 273, (Object)nArray));
                arrayList.remove(entry2);
                arrayList.add(new TIFFEntry(bl ? 325 : 279, (Object)nArray3));
                bl2 = true;
            }
            if (!bl2 && entry != null && entry2 != null) {
                nArray = this.writeData((long[])object4, (long[])object3, imageOutputStream);
                arrayList.remove(entry);
                arrayList.add(new TIFFEntry(bl ? 324 : 273, (Object)nArray));
            }
            if (entry4 != null && arrayList.contains(entry4) || entry5 != null && arrayList.contains(entry5)) {
                throw new IOException("Failed to transform old-style JPEG");
            }
            object2 = directory.getEntryById(519);
            object = directory.getEntryById(520);
            Entry entry6 = directory.getEntryById(521);
            if (object2 != null || object != null || entry6 != null) {
                Entry entry7;
                if (directory.getEntryById(347) != null) {
                    throw new IOException("Found old-style and new-style JPEGTables");
                }
                n = this.jfifContainsTables((Entry)object2, lArray2, lArray) ? 1 : 0;
                n &= this.jfifContainsTables((Entry)object, lArray2, lArray);
                if ((n &= this.jfifContainsTables(entry6, lArray2, lArray)) == 0 && (entry7 = this.mergeTables((Entry)object2, (Entry)object, entry6)) != null) {
                    arrayList.add(entry7);
                }
                if (object2 != null) {
                    arrayList.remove(object2);
                }
                if (object != null) {
                    arrayList.remove(object);
                }
                if (entry6 != null) {
                    arrayList.remove(entry6);
                }
            }
            if (entry3 != null && n2 == 6) {
                arrayList.remove(entry3);
                arrayList.add(new TIFFEntry(259, 3, 7));
            }
            return arrayList;
        }

        private void writeSOF0(ImageOutputStream imageOutputStream, int n, int n2, int n3, int n4) throws IOException {
            imageOutputStream.writeShort(65472);
            imageOutputStream.writeShort(8 + 3 * n);
            imageOutputStream.writeByte(8);
            imageOutputStream.writeShort(n3);
            imageOutputStream.writeShort(n2);
            imageOutputStream.writeByte(n);
            for (int i = 0; i < n; ++i) {
                imageOutputStream.writeByte(i);
                imageOutputStream.writeByte(i == 0 ? n4 : 17);
                imageOutputStream.writeByte(i);
            }
        }

        private void writeSOS(ImageOutputStream imageOutputStream, int n) throws IOException {
            imageOutputStream.writeShort(65498);
            imageOutputStream.writeShort(6 + 2 * n);
            imageOutputStream.writeByte(n);
            for (int i = 0; i < n; ++i) {
                imageOutputStream.writeByte(i);
                imageOutputStream.writeByte(i == 0 ? i : 16 + (i & 0xF));
            }
            imageOutputStream.writeByte(0);
            imageOutputStream.writeByte(0);
            imageOutputStream.writeByte(0);
        }

        private void writeData(ImageInputStream imageInputStream, ImageOutputStream imageOutputStream, long l, long l2) throws IOException {
            imageInputStream.seek(l);
            byte[] byArray = new byte[(int)l2];
            this.stream.readFully(byArray);
            imageOutputStream.write(byArray);
        }

        private boolean jfifContainsTables(Entry entry, long[] lArray, long[] lArray2) throws IOException {
            if (lArray2 == null || lArray == null || lArray2.length == 0) {
                return false;
            }
            if (entry != null) {
                long[] lArray3;
                for (long l : lArray3 = this.getValueAsLongArray(entry)) {
                    if (l >= lArray[0] && l <= lArray[0] + lArray2[0]) continue;
                    return false;
                }
            }
            return true;
        }

        private Entry mergeTables(Entry entry, Entry entry2, Entry entry3) throws IOException {
            long[] lArray;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeShort(65496);
            if (entry != null && entry.valueCount() > 0) {
                lArray = this.getValueAsLongArray(entry);
                byte[] byArray = new byte[64];
                for (int i = 0; i < lArray.length; ++i) {
                    try {
                        this.stream.seek(lArray[i]);
                        this.stream.readFully(byArray);
                        dataOutputStream.writeShort(65499);
                        dataOutputStream.writeShort(67);
                        dataOutputStream.writeByte(i);
                        dataOutputStream.write(byArray);
                        continue;
                    }
                    catch (EOFException eOFException) {
                        // empty catch block
                    }
                }
            }
            if (entry2 != null && entry2.valueCount() > 0) {
                lArray = this.getValueAsLongArray(entry2);
                for (int i = 0; i < lArray.length; ++i) {
                    try {
                        this.stream.seek(lArray[i]);
                        byte[] byArray = this.readHUFFTable();
                        if (byArray.length > 33) continue;
                        dataOutputStream.writeShort(65476);
                        dataOutputStream.writeShort(3 + byArray.length);
                        dataOutputStream.writeByte(i);
                        dataOutputStream.write(byArray);
                        continue;
                    }
                    catch (EOFException eOFException) {
                        // empty catch block
                    }
                }
            }
            if (entry3 != null && entry3.valueCount() > 0) {
                lArray = this.getValueAsLongArray(entry3);
                for (int i = 0; i < lArray.length; ++i) {
                    try {
                        this.stream.seek(lArray[i]);
                        byte[] byArray = this.readHUFFTable();
                        if (byArray.length > 272) continue;
                        dataOutputStream.writeShort(65476);
                        dataOutputStream.writeShort(3 + byArray.length);
                        dataOutputStream.writeByte(0x10 | i);
                        dataOutputStream.write(byArray);
                        continue;
                    }
                    catch (EOFException eOFException) {
                        // empty catch block
                    }
                }
            }
            dataOutputStream.writeShort(65497);
            byteArrayOutputStream.close();
            if (byteArrayOutputStream.size() == 4) {
                return null;
            }
            return new TIFFEntry(347, 7, byteArrayOutputStream.toByteArray());
        }

        private byte[] readHUFFTable() throws IOException {
            byte[] byArray = new byte[16];
            this.stream.readFully(byArray);
            int n = 0;
            for (int i = 0; i < byArray.length; ++i) {
                n += byArray[i] & 0xFF;
            }
            byte[] byArray2 = new byte[16 + n];
            System.arraycopy(byArray, 0, byArray2, 0, 16);
            this.stream.readFully(byArray2, 16, n);
            return byArray2;
        }

        private int[] writeData(long[] lArray, long[] lArray2, ImageOutputStream imageOutputStream) throws IOException {
            int[] nArray = new int[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                nArray[i] = (int)imageOutputStream.getStreamPosition();
                this.stream.seek(lArray[i]);
                byte[] byArray = new byte[(int)lArray2[i]];
                try {
                    this.stream.readFully(byArray);
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
                imageOutputStream.write(byArray);
            }
            return nArray;
        }

        private long[] getValueAsLongArray(Entry entry) throws IIOException {
            long[] lArray;
            if (entry.valueCount() == 1) {
                lArray = new long[]{((Number)entry.getValue()).longValue()};
            } else if (entry.getValue() instanceof short[]) {
                short[] sArray = (short[])entry.getValue();
                lArray = new long[sArray.length];
                int n = lArray.length;
                for (int i = 0; i < n; ++i) {
                    lArray[i] = sArray[i];
                }
            } else if (entry.getValue() instanceof int[]) {
                int[] nArray = (int[])entry.getValue();
                lArray = new long[nArray.length];
                int n = lArray.length;
                for (int i = 0; i < n; ++i) {
                    lArray[i] = nArray[i];
                }
            } else if (entry.getValue() instanceof long[]) {
                lArray = (long[])entry.getValue();
            } else {
                throw new IIOException(String.format("Unsupported %s type: %s (%s)", entry.getFieldName(), entry.getTypeName(), entry.getValue().getClass()));
            }
            return lArray;
        }

        public void rotate(int n) {
            Validate.isTrue(n % 90 == 0 && n > 0 && n < 360, "Only rotations by 90, 180 and 270 degree are supported");
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Iterator iterator = this.IFD.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            short s = 1;
            Entry entry = this.IFD.getEntryById(274);
            if (entry != null) {
                s = ((Number)entry.getValue()).shortValue();
                arrayList.remove(entry);
            }
            int n2 = n / 90;
            block11: for (int i = 0; i < n2; ++i) {
                switch (s) {
                    case 1: {
                        s = 6;
                        continue block11;
                    }
                    case 2: {
                        s = 7;
                        continue block11;
                    }
                    case 3: {
                        s = 8;
                        continue block11;
                    }
                    case 4: {
                        s = 5;
                        continue block11;
                    }
                    case 5: {
                        s = 2;
                        continue block11;
                    }
                    case 6: {
                        s = 3;
                        continue block11;
                    }
                    case 7: {
                        s = 4;
                        continue block11;
                    }
                    case 8: {
                        s = 1;
                    }
                }
            }
            arrayList.add(new TIFFEntry(274, (Object)s));
            this.IFD = new IFD(arrayList);
        }
    }
}

