AJS.toInit(function () {

    var galleryWidth = $("#gallery-width").val();
    var galleryHeight = $("#gallery-height").val();

    updateSlideshowCss(galleryWidth, galleryHeight);

    var slideIndex = 1;
    showSlides(slideIndex);

// Next/previous controls
    function plusSlides(n) {
        showSlides(slideIndex += n);
    }

// Thumbnail image controls
    function currentSlide(n) {
        showSlides(slideIndex = n);
    }

    function showSlides(n) {
        var i;
        var slides = document.getElementsByClassName("picSlides");
        //var dots = document.getElementsByClassName("dot");
        if (n > slides.length) {slideIndex = 1}
        if (n < 1) {slideIndex = slides.length}
        for (i = 0; i < slides.length; i++) {
            slides[i].style.display = "none";
        }
        // for (i = 0; i < dots.length; i++) {
        //     dots[i].className = dots[i].className.replace(" active", "");
        // }
        slides[slideIndex-1].style.display = "block";
        //dots[slideIndex-1].className += " active";
    }


    $('.prevSlide').click(function() {
       plusSlides(-1);
    });

    $('.nextSlide').click(function() {
        plusSlides(1);
    });

    $(window).resize(function() {
        updateSlideshowCss(galleryWidth, galleryHeight);
    });
});

function updateSlideshowCss(galleryWidth, galleryHeight){
    //get screen width to be used for responsiveness
    var screenWidth = $(window).width();

    //make sure width and height are set if it has no value
    if(!galleryWidth && !galleryHeight){
        galleryWidth = "600";
        galleryHeight = "300";
    }
    else if(galleryWidth === "600" && galleryHeight === "300") {
        //just return cause 600 and 300 is already set default in css
        return;
    }

    //when screen is less 600px and width is 600 or greater resize our dimensions
    //we can add more rules in here.
    if(screenWidth <= 600 && galleryWidth >= 600) {
        galleryWidth = "300";
        galleryHeight = "180";
    }

    //update slideshow container
    var slideContainerCss = {"height": galleryHeight+"px",
        "width": galleryWidth+"px",
        "max-height": galleryHeight+"px",
        "max-width": galleryWidth+"px"}

    var slideImageCss = {"max-width": galleryWidth - 100 +"px",
        "max-height": galleryHeight+"px"};
    /*later add a gallery id attribute in the div so we can update the specific galleries style needs.
    for multiple galleries*/

    $(".slideshow-container").css(slideContainerCss);
    $(".slideshow-image").css(slideImageCss);
}