/*
 * Decompiled with CFR 0.152.
 */
package de.xalt.confluence.plugins.util;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.Attachment;
import de.xalt.confluence.plugins.model.Gallery;
import de.xalt.confluence.plugins.util.GallerySize;

public class XaltGalleryUtil {
    public static final String PREFIX = "de.xalt.confluence.plugins.";
    public static final String XALT_GALLERY_MACRO_KEY = "de.xalt.confluence.plugins.advanced-gallery-macro.xalt-gallery";
    public static final String XALT_GALLERY_SETTING_KEY = "de.xalt.confluence.plugins.advanced-gallery-macro.xalt-gallery-setting";
    public static final String XALT_GALLERY_MACRO_NAME = "xalt-gallery";
    public static final String XALT_GALLERY_THUMBNAILS_KEY = "de.xalt.confluence.plugins.advanced-gallery-macro.xalt-gallery_thumbnails";

    public static boolean isLandscapeImage(Integer width, Integer height) {
        return width > height;
    }

    public static boolean isXaltGalleryImageScaled(Attachment thumbnailAttachment) {
        if (thumbnailAttachment != null) {
            boolean isThumbnailExist = false;
            boolean isScaleExist = false;
            for (Label label : thumbnailAttachment.getLabels()) {
                if (label.getDisplayTitle().equals("xalt-gallery-thumbnail")) {
                    isThumbnailExist = true;
                }
                if (!label.getDisplayTitle().equals("xalt-gallery-scale")) continue;
                isScaleExist = true;
            }
            return isThumbnailExist || isScaleExist;
        }
        return false;
    }

    public static void checkAndSetGallerySize(Gallery gallery) {
        GallerySize gallerySize = GallerySize.getSizeByName(gallery.getGallerySize());
        if (gallerySize == null) {
            gallerySize = GallerySize.getSizeByDimensions(gallery.getGalleryWidth() + "x" + gallery.getGalleryHeight());
            gallery.setGallerySize(gallerySize.name());
        }
        gallery.setGalleryWidth(gallerySize.getWidth());
        gallery.setGalleryHeight(gallerySize.getHeight());
    }
}

