/*
 * Decompiled with CFR 0.152.
 */
package de.xalt.confluence.plugins.util;

public enum GallerySize {
    SMALL("small", "600x300", "600", "300"),
    MEDIUM("medium", "900x600", "900", "600"),
    LARGE("large", "1200x900", "1200", "900");

    private String size;
    private String dimensions;
    private String width;
    private String height;

    private GallerySize(String size, String dimensions, String width, String height) {
        this.size = size;
        this.dimensions = dimensions;
        this.width = width;
        this.height = height;
    }

    public static final GallerySize getSizeByDimensions(String dimensions) {
        for (GallerySize currentSize : GallerySize.values()) {
            if (!currentSize.getDimensions().equals(dimensions)) continue;
            return currentSize;
        }
        return null;
    }

    public static final GallerySize getSizeByName(String name) {
        for (GallerySize currentSize : GallerySize.values()) {
            if (!currentSize.name().equalsIgnoreCase(name)) continue;
            return currentSize;
        }
        return null;
    }

    public String getSize() {
        return this.size;
    }

    public String getDimensions() {
        return this.dimensions;
    }

    public String getWidth() {
        return this.width;
    }

    public String getHeight() {
        return this.height;
    }
}

