var viewGallery = function($, macroUtils) {
    var $galleryView;
    var E_GALLERY;
    var GALLERY_IMAGES = [];
    var SWIPER;
    var X_MODAL_SLIDE_INDEX;
    var CURRENT_MODAL_SLIDE_IMAGE;
    var GALLERY_SIZES = {
        SMALL : 30,
        MEDIUM : 60,
        LARGE : 100
    }
    var GALLERY_SIZES_SETTINGS = {
        SMALL: 'xgm-slideshow-small',
        MEDIUM: 'xgm-slideshow-medium',
        LARGE: 'xgm-slideshow-large',
    }

    var $this = {
        loadGalleryData: function(galleryName) {
            var url = macroUtils.getGalleryRESTLink()+'/'+encodeURIComponent(galleryName) + '?pageId=' + macroUtils.getPageId();
            return $.ajax({
                url: url,
                type: 'GET',
                dataType: 'json'
            })
            .fail(function(xhr, textStatus, errorThrown) {
                console.log('Error getting gallery ='+galleryName, textStatus, errorThrown);
            });
        },
        getDisplayImageURL: function(image) {
            var imageURL;
            if(image.scaledImageURL && image.scaledImageURL !== "") {
                imageURL = image.scaledImageURL;
            } else {
                imageURL = macroUtils.getContextPath() + image.linkDownload;
            }
            return imageURL;
        },
        getImageSrcSet: function(image) {
            var imageSrcSet;
            if(image.scaled2xImageURL && image.scaled2xImageURL !== "") {
                imageSrcSet = image.scaled2xImageURL + " 2x";
            }
            return imageSrcSet;
        },
        appendImagesToSwiper: function(images) {
            $.each(images, function(i, image) {
                i += 1;
                if (macroUtils.isSupportedImage(image.mediaType)) {
                    var attachmentId = macroUtils.getAttachmentIdFromString(image.id);
                    var imageName = image.fileName;
                    var imageURL = $this.getDisplayImageURL(image);
                    var imageSrcSet = $this.getImageSrcSet(image);
                    $galleryView.find(".swiper-wrapper.xgm-swiper-wrapper").append(
                      '<div class="xgme-slideshow-swiper swiper-slide"> ' +
                      '<div class="slide-contents"> ' +
                      '<img src="'+imageURL+'" ' +
                      'class="slideshow-image x-modal-img" border="0" img-ctr="'+i+'" ' +
                      'data-linked-resource-default-alias="'+imageName+'" ' +
                      'data-linked-resource-id="'+attachmentId+'" ' +
                      'data-linked-resource-container-id="'+image.contentId+'" ' +
                      'data-linked-resource-selection="'+image.contentId+'"' +
                      (imageSrcSet ? 'srcset="' +imageSrcSet + '"' : '') + '/> ' +
                      // footer info
                      '<div class="slideshow-footer">' +
                      '<div class="slideshow-footer__caption">'+
                      (image.captions.value ? image.captions.value : '&nbsp;')+
                      '</div>' +
                      (E_GALLERY.showCopyright && !!(image.copyright.trim()) ?
                        '<div class="slideshow-footer__copyright">&copy; '+image.copyright+'</div>' : '') +
                      '</div>' +
                      '</div>' +
                      '</div>');
                }
            });
        },
        appendImagesToMasonry: function(images) {
            $galleryView.find(".xgm-masonry-container").append('<div class="xgm-masonry-sizer"></div>');
            $.each(images, function(i, image) {
                i += 1;
                if (macroUtils.isSupportedImage(image.mediaType)) {
                    var attachmentId = macroUtils.getAttachmentIdFromString(image.id);
                    var imageName = image.fileName;
                    var imageURL = $this.getDisplayImageURL(image);
                    var imageSrcSet = $this.getImageSrcSet(image);

                    $galleryView.find(".xgm-masonry-container").append(
                      '<div class="xgm-masonry-item"> ' +
                        (!!image.copyright || !!image.captions.value ?
                        '<div class="xgm-masonry-item-overlay">' :
                        '<div class="xgm-masonry-item-overlay" style="padding:0">') +
                        '<div class="xgme-preview-caption">'+image.captions.value+'</div>' +
                        (E_GALLERY.showCopyright && !!(image.copyright.trim()) ?
                        '<div class="slideshow-footer__copyright">&copy; '+image.copyright+'</div>' : '') +
                        '</div>' +
                       '<img src="'+imageURL+'" ' +
                       'class="xgm-masonry-image x-modal-img" border="0" img-ctr="'+i+'" ' +
                       'data-image-src="'+macroUtils.getContextPath()+image.linkDownload+'" ' +
                       'data-linked-resource-default-alias="'+imageName+'" ' +
                       'data-linked-resource-id="'+attachmentId+'" ' +
                       'data-linked-resource-container-id="'+image.contentId+'" ' +
                       'data-linked-resource-selection="'+image.contentId+'"' + (imageSrcSet ? 'srcset="' +imageSrcSet + '"' : '') + '/> ' +
                      '</div>');
                }
            });
        },
        appendImagesToGrid: function(images) {
            $galleryView.find(".xgm-grid-container").append('<div class="xgm-grid-sizer"></div>');
            $.each(images, function(i, image) {
                i += 1;
                if (macroUtils.isSupportedImage(image.mediaType)) {
                    var attachmentId = macroUtils.getAttachmentIdFromString(image.id);
                    var imageName = image.fileName;
                    var imageURL = $this.getDisplayImageURL(image);
                    var imageSrcSet = $this.getImageSrcSet(image);
                    $galleryView.find(".xgm-grid-container").append(
                        '<div class="xgm-grid-item">'+
                            (!!image.copyright || !!image.captions.value ?
                            '<div class="xgm-grid-item-overlay">' :
                            '<div class="xgm-grid-item-overlay" style="padding:0">') +
                            '<div class="xgme-preview-caption">'+image.captions.value+'</div>' +
                            (E_GALLERY.showCopyright && !!(image.copyright.trim()) ?
                                '<div class="slideshow-footer__copyright">&copy; '+image.copyright+'</div>' : '') +
                            '</div>' +

                            '<img src="'+imageURL+'" ' +
                            'class="xgm-grid-image x-modal-img" img-ctr="'+i+'" ' +
                            // 'data-image-src="'+macroUtils.getContextPath()+image.linkDownload+'" ' +
                            'data-linked-resource-default-alias="'+imageName+'" ' +
                            'data-linked-resource-id="'+attachmentId+'" ' +
                            'data-linked-resource-container-id="'+image.contentId+'" ' +
                            'data-linked-resource-selection="'+image.contentId+'"' +
                            (imageSrcSet ? 'srcset="' +imageSrcSet + '"' : '') + '/> ' +
                        '</div>');
                }
            });
        },
        updateMasonryCss: function(numberOfImages) {
            if (numberOfImages < 4) {
                if(numberOfImages == 2) {
                    $('.xgm-masonry-sizer,.xgm-masonry-item').css('width', '50%');
                    return;
                } else if(numberOfImages == 1) {
                    $('.xgm-masonry-sizer,.xgm-masonry-item').css('width', '100%');
                    return;
                }
                // for 3 images
                $('.xgm-masonry-sizer,.xgm-masonry-item').css('width', '30%');
            }
        },
        initMasonry: function() {
            // init Masonry
            var $masonryGrid = $('.xgm-masonry-container').imagesLoaded( function() {
                $('#xgm-aui-spinner').hide();
                $galleryView.find(".xgm-masonry-container").show();

                // init Masonry after all images have loaded
                $masonryGrid.masonry({
                    // options...
                    itemSelector: '.xgm-masonry-item',
                    columnWidth: '.xgm-masonry-sizer',
                    percentPosition: true
                });
            });
        },
        initMasonryCustomEvent: function() {
            var containers = $('.xgm-masonry-container');
            if (containers.size() > 0) {
                // Check if div elements are resized then re-align masonry images
                new ResizeSensor(containers, function(){
                    $this.initMasonry();
                });
            }
        },
        initSlideshow: function(gallerySettings) {
            $this.updateSlideshowCss(gallerySettings.gallerySize);

            var slideIndex = 1;
            showSlides(slideIndex);

            // Next/previous controls
            function plusSlides(n) {
                showSlides(slideIndex += n);
            }

            // Thumbnail image controls
            function currentSlide(n) {
                showSlides(slideIndex = n);
            }

            function showSlides(n) {
                var i;
                var slides = $galleryView.find(".picSlides");
                //var dots = document.getElementsByClassName("dot");
                if (n > slides.length) {slideIndex = 1}
                if (n < 1) {slideIndex = slides.length}
                for (i = 0; i < slides.length; i++) {
                    slides[i].style.display = "none";
                    slides[i].classList.remove("active");
                }
                // for (i = 0; i < dots.length; i++) {
                //     dots[i].className = dots[i].className.replace(" active", "");
                // }
                slides[slideIndex-1].style.display = "flex";
                slides[slideIndex-1].className += " active";
                //dots[slideIndex-1].className += " active";
            }

            $galleryView.find(".prevSlide").click(function() {
                plusSlides(-1);
            });

            $galleryView.find(".nextSlide").click(function() {
                plusSlides(1);
            });
        },
        updateSlideshowCss: function(gallerySize) {
            var currentGalleryWidth = 30;
            var currentGalleryHeight = 100;
            if (GALLERY_SIZES.MEDIUM === gallerySize) {
                currentGalleryWidth = 60;
            }
            if (GALLERY_SIZES.LARGE === gallerySize) {
                currentGalleryWidth = 100;
            }

            //update slideshow container
            var slideContainerCss = {"height": currentGalleryHeight+"%",
                "width": currentGalleryWidth+"%",
                "max-width": currentGalleryWidth + "%",
                "max-height": currentGalleryHeight + "%"
            }

            var slideImageCss = {"max-width": "100%",
                "max-height": "100%"};
            /* later add a gallery id attribute in the div, so we can update the specific galleries style needs.
            for multiple galleries */

            $galleryView.find(".xgm-slideshow-container").css(slideContainerCss);
            $galleryView.find(".slideshow-image").css(slideImageCss);
        },
        appendImagesToModal: function(images) {
            $.each(images, function(i, image) {
                i += 1;
                if (macroUtils.isSupportedImage(image.mediaType)) {
                    var attachmentId = macroUtils.getAttachmentIdFromString(image.id);
                    var imageName = image.fileName;
                    $galleryView.find(".x-modal-content").append(
                        '<div class="x-modal-slides"> ' +
                            '<div class="x-modal-slide-metadata">' +
                                '<div>' +
                                    '<span class="x-modal-slide-caption">'+image.captions.value+'</span>' +
                                    (E_GALLERY.showCopyright && !!(image.copyright.trim()) ?
                                    '<span class="x-modal-slide-copyright">&copy; '+image.copyright+'</span>' : '') +
                                '</div>' +
                                '<div>' +
                                    '<span class="x-modal-comment">'+AJS.I18n.getText("de.xalt.confluence.plugins.confluence-gallery-comments.label")+'</span>'+
                                    '<span class="x-modal-close x-modal-cursor">&times;</span>' +
                                '</div>' +
                            '</div>' +
                            '<img class="x-modal-image" data-image-src="'+macroUtils.getContextPath()+image.linkDownload+'" />' +
                            '<img id="modal-slide-'+i+'"' +
                            'class="confluence-embedded-image" style="width:1%;height:1%; display:none;" ' +
                            // 'data-image-src="'+macroUtils.getThumbnailLink(imageName, null)+'" ' +
                            'data-linked-resource-default-alias="'+imageName+'" ' +
                            'data-linked-resource-id="'+attachmentId+'" ' +
                            'data-linked-resource-container-id="'+image.contentId+'" ' +
                            'data-linked-resource-selection="'+image.contentId+'" /> ' +
                        '</div>');
                }
            });
        },
        initXModal: function() {
            X_MODAL_SLIDE_INDEX = 1;
            CURRENT_MODAL_SLIDE_IMAGE;

            $galleryView.find(".x-modal-img").click(function(){
                var imgCtr = $(this).attr('img-ctr');
                $this.openModal();
                $this.xModalCurrentSlide(parseInt(imgCtr));
            });

            $galleryView.find(".x-modal-close").click(function(){
                $this.closeModal();
            });

            $galleryView.find(".x-modal-prev").click(function(){
                $this.xModalPlusSlides(-1);
            });

            $galleryView.find(".x-modal-next").click(function(){
                $this.xModalPlusSlides(1);
            });

            $galleryView.find(".x-modal-comment").click(function(){
                CURRENT_MODAL_SLIDE_IMAGE.click();
                // console.log(X_MODAL_SLIDE_INDEX);
                // $("#modal-slide-"+X_MODAL_SLIDE_INDEX).addClass("confluence-embedded-image");
                // $("#modal-slide-"+X_MODAL_SLIDE_INDEX).click();
            });

            $(document).keydown(function (e) {
                //check if preview window is open
                if($galleryView.find("#x-preview").css('display') != 'none') {
                    //left arrow key
                    if(e.keyCode === 37) {
                        $this.xModalPlusSlides(-1);
                    }
                    //right arrow key
                    if(e.keyCode === 39) {
                        $this.xModalPlusSlides(1);
                    }

                    //esacape key
                    if(e.keyCode === 27) {
                        $this.closeModal();
                    }
                }
            });
        },
        xModalShowSlides: function(n) {
            //TODO remove white line in image inside the modal - modal-content bacgkround:color;
            var i;
            var slides = $galleryView.find(".x-modal-slides");
            var commentSpans = $galleryView.find(".x-comment-span");
            //var captionText = document.getElementById("x-modal-caption");
            if (n > slides.length) {X_MODAL_SLIDE_INDEX = 1}
            if (n < 1) {X_MODAL_SLIDE_INDEX = slides.length}
            for (i = 0; i < slides.length; i++) {
                slides[i].style.display = "none";
            }
            slides[X_MODAL_SLIDE_INDEX-1].style.display = "contents";

            //captionText.innerHTML = dots[slideIndex-1].alt;
            CURRENT_MODAL_SLIDE_IMAGE = $(slides[X_MODAL_SLIDE_INDEX-1]).find('img');
            CURRENT_MODAL_SLIDE_IMAGE.attr('src', CURRENT_MODAL_SLIDE_IMAGE.attr('data-image-src'));
        },
        // Open the Modal
        openModal: function() {
            //document.getElementById('x-preview').style.display = "block";
            $galleryView.find("#x-preview").show();
        },
        // Close the Modal
        closeModal: function() {
            //document.getElementById('x-preview').style.display = "none";
            $galleryView.find("#x-preview").hide();
        },
        // Next/previous controls
        xModalPlusSlides: function(n) {
            $this.xModalShowSlides(X_MODAL_SLIDE_INDEX += n);
        },
        // Thumbnail image controls
        xModalCurrentSlide: function(n) {
            console.log('x-modal-slide', n);
            $this.xModalShowSlides(X_MODAL_SLIDE_INDEX = n);
        },
        createSwiper: function() {
            SWIPER = new Swiper('.xgm-swiper-container', {
                navigation: {
                    nextEl: '.swiper-next',
                    prevEl: '.swiper-prev',
                },
                pagination: {
                    el: '.swiper-pagination',
                    dynamicBullets: true,
                },
                centeredSlides: true,
                resizeObserver: true,
            });
        },
        isWidthTwiceTheHeight: function (width, height){
            if((height * 2) <= width){
                return true;
            }else{
                return false;
            }
        },
        //method for image check currently unused.
        checkIfImgExists: function(imageUrl) {
            var img = new Image();
            img.src = imageUrl;
            img.onerror = function() {//needs to be a declared function for the variable otherwise it will always trigger if it is a called method
                var warningElement = document.getElementById("xgm-image-error");
                var divContainer = "#xgm-image-loading-error";
                $galleryView.find(divContainer).show();
                var rescaleImageLink = macroUtils.getRescaleImageLink();

                if (warningElement == null || warningElement == undefined) {
                    var brokenImageText = AJS.I18n.getText('de.xalt.confluence.plugins.confluence-broken-image.message');
                    var brokenImageLinkText = AJS.I18n.getText('de.xalt.confluence.plugins.confluence-broken-image.link');
                    $galleryView.find(divContainer).append('<div id="xgm-image-error">' + brokenImageText + ' <a href="'+rescaleImageLink+'">' + brokenImageLinkText + '</a></div>');
                }
            };
        }
    };

    return {
        init: function($container, galleryName) {
            $galleryView = $container;
            if(galleryName) {
                $this.loadGalleryData(galleryName).then(function(res) {
                    E_GALLERY = res;
                    //checks the gallery if it was saved from a draft/new page
                    if(E_GALLERY && E_GALLERY.savedFromDraft && E_GALLERY.pageId !== macroUtils.getPageId()) {
                        AJS.log('gallery saved from draft');
                        macroUtils.updateGalleryFromDraft(E_GALLERY).then(function(updatedGallery){
                            AJS.log('gallery updated from draft');
                            E_GALLERY = updatedGallery;
                            //persist the updated gallery.
                            macroUtils.saveUpdatedGallery(E_GALLERY).then(function() {
                                inner();
                            });
                        });
                    }
                    else{
                        AJS.log('gallery saved from published');
                        inner();
                    }

                    function inner() {
                        // check source gallery page if the gallery still exists
                        if (E_GALLERY.isSourceGalleryDeleted) {
                            $galleryView.find("#xgm-view-loading-gallery").hide();
                            $galleryView.find('#xgm-view-is-gallery-deleted').show();
                            return;
                        }
                        $galleryView.find("#xgm-image-loading-error").hide();
                        if(E_GALLERY && E_GALLERY.name && E_GALLERY.pictures.length > 0) {
                            GALLERY_IMAGES = E_GALLERY.pictures;
                            $galleryView.find("#xgm-view-loading-gallery").hide();

                            if(E_GALLERY.displayType === macroUtils.displayType.SLIDESHOW) {
                                var gallerySizeClass = GALLERY_SIZES_SETTINGS[E_GALLERY.gallerySize];
                                AJS.log('Setting max width: ' + gallerySizeClass);
                                $galleryView.find('.xgm-swiper-container').addClass(gallerySizeClass);


                                $this.appendImagesToSwiper(GALLERY_IMAGES);
                                $galleryView.find(".xgm-slideshow-swiper-container").show();
                                $this.createSwiper();

                                $galleryView.find(".xgm-slideshow-container").css("margin-bottom", $galleryView.find(".slideshow-footer").outerHeight());
                            }
                            else if(E_GALLERY.displayType === macroUtils.displayType.GRID) {
                                $galleryView.find(".xgm-grid-container").css('display', 'flex');
                                $this.appendImagesToGrid(GALLERY_IMAGES);
                            } else {
                                $('#xgm-aui-spinner').show();
                                $this.appendImagesToMasonry(GALLERY_IMAGES);
                                $this.updateMasonryCss(GALLERY_IMAGES.length);
                                $this.initMasonry();
                                $this.initMasonryCustomEvent();
                            }
                            $this.appendImagesToModal(GALLERY_IMAGES);
                            $this.initXModal();
                        }
                        else {
                            $galleryView.find("#xgm-view-loading-gallery").hide();
                            $galleryView.find("#xgm-view-no-pictures").show();
                            $galleryView.find("#xgm-view").hide();
                        }
                    }

                    if (E_GALLERY && !E_GALLERY.imagesScaled && !E_GALLERY.scalingImages) {
                        AJS.log('All Images have not been scaled to current setting.' +
                          ' Attempting to re-scale images for: ' + galleryName);
                        macroUtils.scaleGalleryImages(galleryName);
                    }

                    // Add class for gallery to be fixed.
                    if (E_GALLERY && E_GALLERY.displayType === macroUtils.displayType.SLIDESHOW) {
                        if ($galleryView.closest('table').length) {
                            $galleryView.find('.swiper-container')
                              .addClass('slideshow-table-cell-view-' + E_GALLERY.gallerySize.toLowerCase());
                        }
                    }
                })
            }
        }
    };
}
