(function (AJS, $, progressContainer) {
  XALT.AdvancedGallery.Admin = (function () {
    function init() {
      $('#advanced-gallery-config-form').on('submit', function (e) {
        e.preventDefault();
        $('#advanced-gallery-re-scale-btn').disable();

        reScaleGalleries().then(function (res) {
          // AJS.flag({type: 'success', body: AJS.I18n.getText('xalt-advanced-gallery-configuration.re-scale.task.started.msg'),
          //   close: 'auto'});

          progressContainer.init(res.taskID);
        });
      });
    }

    function reScaleGalleries() {
      var url = AJS.Meta.get('context-path') + '/rest/xalt-gallery/1.0/admin-config/rescale';
      return $.ajax({
        url: url,
        type: 'PUT'
      })
        .fail(function (xhr, textStatus, errorThrown) {
          AJS.log('Error request for re-scaling the galleries', textStatus, errorThrown);
        });
    }

    return {
      init: init
    };
  })();
  AJS.toInit(XALT.AdvancedGallery.Admin.init);
})(AJS, AJS.$, XALT.AdvancedGallery.Admin.ProgressContainer);
