var xaltGalleryMacroUtils = function($, macro) {
    var macroName = "xalt-gallery";

    var $this = {
        displayType: {
          "SLIDESHOW": "slideshow",
          "GRID": "grid",
          "MASONRY": "masonry",
        },
        getSpaceKey: function() {
            return AJS.Meta.get('space-key');
        },
        getPageId: function() {
            return AJS.Meta.get('page-id') > 0 ? AJS.Meta.get('page-id') : AJS.Meta.get('draft-id');
        },
        getContentStatus: function() {
            return AJS.Meta.get('page-id') <= 0 ? "draft" : "current";
        },
        getContextPath: function() {
            return AJS.Meta.get('context-path');
        },
        getGalleryRESTLink: function() {
            return (this.getContextPath() + "/rest/xalt-gallery/1.0/xalt-gallery");
        },
        getPOSTAttachmentRESTLink: function() {
            return ($this.getContextPath() + "/rest/api/content/" + $this.getPageId() + "/child/attachment?status=" +
            $this.getContentStatus() + "&allowDuplicated=true&expand=version,container,space");
        },
        getPOSTCropImageRESTLink: function(attachmentName, galleryName) {
            return (this.getContextPath() + '/rest/xalt-gallery/1.0/scale-image/crop?pageId=' + $this.getPageId() +
              "&galleryName=" + galleryName +
              "&attachmentName=" + encodeURIComponent(attachmentName));
        },
        getPOSTCropImageV2RESTLink: function(attachmentName, galleryName) {
            return (this.getContextPath() + '/rest/xalt-gallery/1.0/scale-image/crop-v2?pageId=' + $this.getPageId() +
              "&galleryName=" + galleryName +
              "&attachmentName=" + encodeURIComponent(attachmentName));
        },
        getPOSTScaleImageRESTLink: function(attachmentName, gallerySettings) {
            return ($this.getContextPath() + "/rest/xalt-gallery/1.0/scale-image?pageId=" + $this.getPageId() +
              "&galleryWidth=" + gallerySettings.galleryWidth + "&galleryHeight="+gallerySettings.galleryHeight +
              "&attachmentName=" + encodeURIComponent(attachmentName));
        },
        getPOSTScaleGalleryImagesRESTLink: function(galleryName) {
            return ($this.getContextPath() + "/rest/xalt-gallery/1.0/scale-image/gallery?galleryName=" + galleryName +
              "&pageId=" + $this.getPageId());
        },
        getAttachmentRESTLink: function() {
            return ($this.getContextPath() + "/rest/api/content/" + $this.getPageId() + "/child/attachment?expand=" +
                "version,container,space&limit=100");
        },
        getThumbnailLink: function(imageFileName, versionDate) {
            return $this.getContextPath() + "/download/thumbnails/" + $this.getPageId() + "/" +
              encodeURIComponent(imageFileName) + "?api=v2&nonce="+versionDate;
        },
        getRescaleImageLink: function() {
            return $this.getContextPath() + "/admin/plugins/xalt-advanced-gallery-configuration/configure.action";
        },
        getAttachmentIdFromString: function(attachmentId) {
            return attachmentId.substring(attachmentId.lastIndexOf('t')+1, attachmentId.length);
        },
        getAttachments: function() {
            return $.ajax({
               url: $this.getAttachmentRESTLink(),
               type: 'GET'
            })
            .fail(function(xhr, textStatus, errorThrown) {
                console.log('Error getting attachments of page ='+$this.getPageId(), textStatus, errorThrown);
            });
        },
        updateGalleryFromDraft: function(gallery) {
            var dfd = $.Deferred();

            gallery.savedFromDraft = false;
            gallery.isSourceGalleryDeleted = false;
            gallery.pageId = $this.getPageId();

            if(gallery.pictures.length > 0) {
                $this.getAttachments().then(function(attachments) {
                    gallery.pictures.map(function (pic) {
                        $.each(attachments.results, function(i, attachment) {
                            if(pic.id === attachment.id) {
                                pic.contentId = attachment.container.id;
                                pic.linkDownload = attachment._links.download;
                                return pic;
                            }
                        });
                    });
                    dfd.resolve(gallery);
                });
            }
            else{
                dfd.resolve(gallery);
            }

            return dfd.promise();
        },
        saveUpdatedGallery: function(gallery) {
            var url = $this.getGalleryRESTLink();
            url += '/' + encodeURIComponent(gallery.name);

            return $.ajax({
                url: url,
                type: 'PUT',
                data: JSON.stringify(gallery),
                contentType: 'application/json',
            })
            .fail(function() {
                console.log('save updated gallery failed');
            });
        },
        isSupportedImage: function (imageType) {
            if(imageType === 'image/jpeg'
                || imageType === 'image/png') {
                return true;
            }
            return false;
        },
        scaleGalleryImages: function (galleryName) {
            return $.ajax({
                url: $this.getPOSTScaleGalleryImagesRESTLink(galleryName),
                headers: {
                    "X-Atlassian-Token": "no-check"
                },
                type: 'POST'
            })
              .fail(function (xhr, textStatus, errorThrown) {
                  AJS.log('Error scaling gallery images of gallery =' + galleryName, textStatus, errorThrown);
              });
        }
    };

    return {
        displayType: $this.displayType,
        getSpaceKey: function() {
            return $this.getSpaceKey();
        },
        getPageId: function() {
            return $this.getPageId();
        },
        getContextPath: function() {
            return $this.getContextPath();
        },
        getPOSTAttachmentRESTLink: function() {
            return $this.getPOSTAttachmentRESTLink();
        },
        getPOSTCropImageRESTLink: function(attachmentName, galleryName) {
            return $this.getPOSTCropImageRESTLink(attachmentName, galleryName);
        },
        getPOSTCropImageV2RESTLink: function(attachmentName, galleryName) {
            return $this.getPOSTCropImageV2RESTLink(attachmentName, galleryName);
        },
        getPOSTScaleImageRESTLink: function(attachmentName, gallerySettings) {
            return $this.getPOSTScaleImageRESTLink(attachmentName, gallerySettings);
        },
        getPOSTScaleGalleryImagesRESTLink: function(galleryName) {
            return $this.getPOSTScaleGalleryImagesRESTLink(galleryName);
        },
        getAttachmentRESTLink: function() {
            return $this.getAttachmentRESTLink();
        },
        getAttachmentByMediaTypeRESTLink: function (mediaType) {
            return $this.getAttachmentByMediaTypeRESTLink(mediaType);
        },
        getThumbnailLink: function(imageFileName, versionDate) {
            return $this.getThumbnailLink(imageFileName, versionDate);
        },
        getAttachmentIdFromString: function(attachmentId) {
            return $this.getAttachmentIdFromString(attachmentId);
        },
        getGalleryRESTLink: function() {
            return $this.getGalleryRESTLink();
        },
        getGallerySettings: function() {
            //temp solution while settings is not finalized
            return $this.getGallerySettings();
        },
        getContentStatus: function() {
            return $this.getContentStatus();
        },
        updateGalleryFromDraft: function(gallery) {
            return $this.updateGalleryFromDraft(gallery);
        },
        saveUpdatedGallery: function(gallery) {
            return $this.saveUpdatedGallery(gallery);
        },
        getRescaleImageLink: function() {
            return $this.getRescaleImageLink();
        },
        isSupportedImage: function(imageType) {
            return $this.isSupportedImage(imageType);
        },
        scaleGalleryImages: $this.scaleGalleryImages,
    }
}