/*
 * Decompiled with CFR 0.152.
 */
package de.xalt.confluence.plugins.service.impl;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.xalt.confluence.plugins.service.GalleryAttachmentService;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportAsService(value={GalleryAttachmentService.class})
@Named(value="galleryAttachmentService")
public class GalleryAttachmentServiceImpl
implements GalleryAttachmentService {
    private static final Logger log = LoggerFactory.getLogger(GalleryAttachmentServiceImpl.class);
    @ComponentImport
    private final AttachmentManager attachmentManager;

    @Inject
    public GalleryAttachmentServiceImpl(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    @Override
    public Attachment getImage(String imageFilename, ContentEntityObject ceo) {
        Attachment attachment = this.getExistingImage(imageFilename, ceo);
        return attachment != null ? attachment : (Attachment)this.attachmentManager.getAttachmentForDownloadPath(imageFilename).getOrNull();
    }

    private Attachment getExistingImage(String imageFileName, ContentEntityObject ceo) {
        return ceo.getAttachments().stream().filter(attachment -> !attachment.isDeleted() && attachment.getFileName().equalsIgnoreCase(imageFileName)).findFirst().orElse(null);
    }

    @Override
    public Attachment processImage(ContentEntityObject ceo, BufferedImage image, Attachment originalImageAttachment, String typeOfImage) {
        ByteArrayOutputStream croppedOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, originalImageAttachment.getFileExtension(), croppedOutputStream);
        }
        catch (IOException var7) {
            return originalImageAttachment;
        }
        return this.createAttachment(croppedOutputStream, originalImageAttachment.getFileName(), ceo, originalImageAttachment, typeOfImage);
    }

    @Override
    public Attachment createAttachment(ByteArrayOutputStream imageOutputStream, String attachmentName, ContentEntityObject targetContentEntity, Attachment originalAttachment, String typeOfImage) {
        ByteArrayInputStream scaledImageInputStream = new ByteArrayInputStream(imageOutputStream.toByteArray());
        Attachment scaledImageAttachment = new Attachment(attachmentName, originalAttachment.getMediaType(), (long)imageOutputStream.size(), this.getCustomVersionCommentForAttachment(originalAttachment, typeOfImage));
        scaledImageAttachment.setLastModificationDate(new Date());
        scaledImageAttachment.setCreator(originalAttachment.getCreator());
        scaledImageAttachment.setTitle(attachmentName);
        scaledImageAttachment.getProperties().setLongProperty("HIDDEN", 1L);
        scaledImageAttachment.setMinorEdit(true);
        targetContentEntity.addAttachment(scaledImageAttachment);
        try {
            this.attachmentManager.saveAttachment(scaledImageAttachment, null, (InputStream)scaledImageInputStream, DefaultSaveContext.MINOR_EDIT);
            return scaledImageAttachment;
        }
        catch (IOException var8) {
            log.warn("Attachment could not be saved", (Throwable)var8);
            return null;
        }
    }

    @Override
    public String getCustomVersionCommentForAttachment(Attachment attachment, String typeOfImage) {
        String customVersionComment = typeOfImage + " gallery image from " + attachment.getFileName() + " (" + attachment.getFileSize() + " bytes) for XALT Advanced Gallery macro";
        return customVersionComment;
    }
}

