/*
 * Decompiled with CFR 0.152.
 */
package de.xalt.confluence.plugins.resources;

import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.google.common.collect.ImmutableMap;
import de.xalt.confluence.plugins.api.GalleryReScaleLongRunningTask;
import de.xalt.confluence.plugins.model.UpdateReferenceConfigRequest;
import de.xalt.confluence.plugins.service.GalleryService;
import de.xalt.confluence.plugins.transaction.ScaleImageTransaction;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/admin-config")
@Scanned
public class XaltGalleryAdminConfig {
    private final Logger log = LoggerFactory.getLogger(XaltGalleryAdminConfig.class);
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    @ComponentImport
    private final LongRunningTaskManager longRunningTaskManager;
    @ComponentImport
    private final PluginSettingsFactory pluginSettingsFactory;
    private final GalleryService galleryService;
    private final ScaleImageTransaction scaleImageTransaction;

    @Inject
    public XaltGalleryAdminConfig(UserManager userManager, TransactionTemplate transactionTemplate, GalleryService galleryService, ScaleImageTransaction scaleImageTransaction, LongRunningTaskManager longRunningTaskManager, PluginSettingsFactory pluginSettingsFactory) {
        this.userManager = userManager;
        this.transactionTemplate = transactionTemplate;
        this.galleryService = galleryService;
        this.scaleImageTransaction = scaleImageTransaction;
        this.longRunningTaskManager = longRunningTaskManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    @PUT
    @Path(value="/rescale")
    @Produces(value={"application/json"})
    public Response post(@Context HttpServletRequest req) {
        UserProfile userProfile = this.userManager.getRemoteUser(req);
        if (userProfile == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        GalleryReScaleLongRunningTask galleryReScaleTask = new GalleryReScaleLongRunningTask(this.galleryService, this.transactionTemplate, this.scaleImageTransaction);
        LongRunningTaskId taskID = this.longRunningTaskManager.startLongRunningTask(null, (LongRunningTask)galleryReScaleTask);
        return Response.ok((Object)ImmutableMap.of((Object)"taskID", (Object)taskID.asLongTaskId())).build();
    }

    @GET
    @Path(value="/get-reference-config")
    @Produces(value={"application/json"})
    public Response getReferenceConfig() {
        UserKey userkey = this.userManager.getRemoteUser().getUserKey();
        if (userkey == null || !this.userManager.isSystemAdmin(userkey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        String referenceMessage = (String)pluginSettings.get("xalt.advanced-image-gallery.reference-config.reference-message");
        HashMap<String, String> responseMap = new HashMap<String, String>();
        responseMap.put("referenceMessage", referenceMessage);
        return Response.ok(responseMap).build();
    }

    @POST
    @Path(value="/update-reference-config")
    @Produces(value={"application/json"})
    public Response updateReferenceConfig(UpdateReferenceConfigRequest updateReferenceConfigRequest) {
        UserKey userkey = this.userManager.getRemoteUser().getUserKey();
        if (userkey == null || !this.userManager.isSystemAdmin(userkey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        String referenceMessageSanitized = Jsoup.clean(updateReferenceConfigRequest.getReferenceMessage(), Safelist.basic());
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        pluginSettings.put("xalt.advanced-image-gallery.reference-config.reference-message", (Object)referenceMessageSanitized);
        updateReferenceConfigRequest.setReferenceMessage(referenceMessageSanitized);
        return Response.ok((Object)updateReferenceConfigRequest).build();
    }
}

