/*
 * Decompiled with CFR 0.152.
 */
package de.xalt.confluence.plugins.api;

import com.atlassian.confluence.util.SubProgressMeter;
import com.atlassian.confluence.util.longrunning.ConfluenceAbstractLongRunningTask;
import com.atlassian.core.util.ProgressMeter;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import de.xalt.confluence.plugins.model.Gallery;
import de.xalt.confluence.plugins.model.GallerySettings;
import de.xalt.confluence.plugins.model.Picture;
import de.xalt.confluence.plugins.model.ReScaleProgress;
import de.xalt.confluence.plugins.service.GalleryService;
import de.xalt.confluence.plugins.transaction.ScaleImageTransaction;
import de.xalt.confluence.plugins.util.ReScaleTaskStatus;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GalleryReScaleLongRunningTask
extends ConfluenceAbstractLongRunningTask {
    private final Logger log = LoggerFactory.getLogger(GalleryReScaleLongRunningTask.class);
    private final GalleryService galleryService;
    private final TransactionTemplate transactionTemplate;
    private final ScaleImageTransaction scaleImageTransaction;

    public GalleryReScaleLongRunningTask(GalleryService galleryService, TransactionTemplate transactionTemplate, ScaleImageTransaction scaleImageTransaction) {
        this.galleryService = galleryService;
        this.transactionTemplate = transactionTemplate;
        this.scaleImageTransaction = scaleImageTransaction;
    }

    protected void runInternal() {
        this.log.debug("Running task: " + this.getName());
        List<Gallery> galleryList = this.galleryService.getAllGalleries("de.xalt.confluence.plugins.advanced-gallery-macro.xalt-gallery");
        int totalImages = this.galleryService.getTotalImages("de.xalt.confluence.plugins.advanced-gallery-macro.xalt-gallery");
        this.log.debug("Total Images of all galleries: " + totalImages);
        this.progress.setStatus(ReScaleTaskStatus.RESCALING.getI18n());
        this.progress.setTotalObjects(totalImages);
        SubProgressMeter reScaleProgressMeter = new SubProgressMeter(this.progress, 1.0f, totalImages);
        ReScaleProgress reScaleProgress = new ReScaleProgress((ProgressMeter)reScaleProgressMeter, totalImages);
        for (Gallery gallery : galleryList) {
            this.log.debug("Gallery: " + gallery.getName() + " PageId: " + gallery.getPageId());
            GallerySettings setting = this.galleryService.getGallerySettings(gallery.getName());
            if (setting.isScalingImages()) {
                this.log.debug("Scaling is already being done for: " + gallery.getName() + ". Proceeding to next one.");
                continue;
            }
            List<Picture> pictureList = gallery.getPictures();
            for (Picture picture : pictureList) {
                this.log.debug("Scaling image " + picture.getFileName() + " imageId: " + picture.getId() + " link: " + picture.getLinkDownload());
                this.transactionTemplate.execute(() -> this.scaleImageTransaction.scaleGalleryTransaction(picture, gallery, pictureList, reScaleProgress));
            }
        }
        reScaleProgressMeter.setPercentage(100);
        reScaleProgressMeter.setStatus(ReScaleTaskStatus.COMPLETED.getI18n());
    }

    public String getName() {
        return "Gallery re-scale long running task";
    }
}

