
var CROPPER;
var xaltGalleryMacroEditor = function ($, macroUtils) {

    var DROPZONE;
    var IMAGE_ATTACHMENTS = [];
    var EDIT_IMAGES = [];
    var SWIPER;

    var ACTIVE_EDIT_IMAGE;
    var FILTER_IMAGE;
    var FILTER_IMG_OBJ;
    var SELECTED_EDIT_SLIDE;
    var PRE_EDIT_IMAGE;
    var EDITED_IMAGE;
    var UNDO = [];
    var REDO = [];
    var REDO_UNDO_TRIGGERED = false;
    

    var FILTEROUS;
    var FILTER_VARS = {};

    var E_GALLERY;
    var IS_GALLERY_ORIGIN = true;
    var IS_LICENSE_OK = true;
    var GALLERY_IMAGES = [];
    var SORTING_TYPE;
    var GALLERY_SETTINGS;

    var MASONRY_GRID;
    var PREV_SWIPER;

    var MAX_GALLERY_NAME = 99;
    var MAX_CAPTION_LENGTH = 100;
    var MAX_COPYRIGHT_LENGTH = 100;

    var CURRENT_IMAGE_INDEX = 0;
    var CURRENT_THUMBNAIL_LINKS = {};
    var IS_TEMPLATE_CONTENT = AJS.params.contentType === 'template';

    $this = {
        tabContent: {
            "CREATE": "xgme-body-create",
            "ADD": "xgme-body-add",
            "PROPERTIES": "xgme-body-properties",
            "EDIT": "xgme-body-edit",
            "PREVIEW": "xgme-body-preview",
            "SETTINGS": "xgme-body-settings",
            "RESTRICTED": "xgme-body-restricted",
        },
        sortingType: {
            "NAME": "name",
            "CUSTOM": "custom",
        },
        saveGalleryV2: function () {
            var dfd = new $.Deferred();
            var displayType = $('input:radio[name=xgme-display-type]:checked').val();
            var galleryWidth = GALLERY_SETTINGS.galleryWidth;
            var galleryHeight = GALLERY_SETTINGS.galleryHeight;
            var thumbnailPercentage = $('#thumbnal-percentage').val();
            var showCopyright = GALLERY_SETTINGS.showCopyright;
            var gallerySize = GALLERY_SETTINGS.gallerySize;
            var displayPlainInMobile = GALLERY_SETTINGS.displayPlainInMobile;

            var gallery = $this.getGallery();
            // set gallery name to uuid if gallery is empty
            gallery.name = E_GALLERY && E_GALLERY.name ? E_GALLERY.name : uuidv4();
            gallery.displayType = displayType;
            gallery.galleryWidth = galleryWidth;
            gallery.galleryHeight = galleryHeight;
            gallery.thumbnailPercentage = thumbnailPercentage;
            gallery.spaceKey = macroUtils.getSpaceKey();
            gallery.pageId = macroUtils.getPageId();
            gallery.pictures = GALLERY_IMAGES;
            gallery.sortingType = SORTING_TYPE;
            gallery.savedFromDraft = (macroUtils.getContentStatus() === 'draft') ? true : false;
            gallery.showCopyright = showCopyright;
            gallery.gallerySize = gallerySize;
            gallery.displayPlainInMobile = displayPlainInMobile;

            //var url = macroUtils.getPOSTGalleryRESTLink(isCreateNew);
            var url = macroUtils.getGalleryRESTLink();
            var type = 'POST';

            if (E_GALLERY) {
                if (!E_GALLERY.name) {
                    E_GALLERY.name = uuidv4();
                }
                url += '/' + encodeURIComponent(E_GALLERY.name);
                type = 'PUT';
            }

            if (IS_TEMPLATE_CONTENT) {
                dfd.resolve({}); // Since it is a template gallery. All data will be blank for the page/blogpost and the default info will be populated once the gallery is opened.
            } else {
                $.ajax({
                    url: url,
                    type: type,
                    data: JSON.stringify(gallery),
                    contentType: 'application/json',
                })
                  .done(function (res) {
                      AJS.log('save gallery done', res);
                      dfd.resolve(gallery);
                  })
                  .fail(function () {
                      AJS.log('save gallery failed');
                      dfd.reject();
                  });
            }

            return dfd.promise();
        },
        getGallery: function () {
            return {
                name: null,
                displayType: null,
                galleryWidth: null,
                thumbnailPercentage: null,
                spaceKey: null,
                pageId: null,
                sortingType: null,
                savedFromDraft: null,
                showCopyright: null,
                displayPlainInMobile: null,
            }
        },
        getGallerySettings: function (gallery, isNewGallery) {
            var displayType = gallery && gallery.displayType ? gallery.displayType : 'slideshow';
            var galleryTypeField = $('#xgm-view-gallery-type').val();

            if (galleryTypeField && galleryTypeField !== 'default' && isNewGallery) {
                displayType = galleryTypeField;
            }

            return {
                galleryWidth: gallery && gallery.galleryWidth ? gallery.galleryWidth : 600,
                galleryHeight: gallery && gallery.galleryHeight ? gallery.galleryHeight : 300,
                displayType: displayType,
                showCopyright: gallery && gallery.showCopyright ? gallery.showCopyright : false,
                gallerySize: gallery && gallery.gallerySize ? gallery.gallerySize : 'SMALL',
                displayPlainInMobile: gallery && gallery.displayPlainInMobile ? gallery.displayPlainInMobile : false,
            }
        },
        getPicture: function (attachment) {
            return {
                id: attachment.id,
                spaceKey: macroUtils.getSpaceKey(),
                fileName: attachment.title,
                contentId: attachment.container.id,
                index: 1,
                when: attachment.version.when,
                mediaType: attachment.metadata.mediaType,
                linkDownload: attachment._links.download,
                captions: { languageCode: "", value: "" },
                copyright: "",
            }
        },
        getUpdatedPicture: function (croppedImageAttachment, beforeCropPicture) {
            // Download link contains a relative path, for manipulation with the URL API we need a valid url
            // this is why we add a dummy host
            const downloadLinkURL = new URL('https://example.com' + croppedImageAttachment.forLinkDownload);
            downloadLinkURL.searchParams.delete('modificationDate');
            const downloadLink = downloadLinkURL.pathname + downloadLinkURL.search;
            console.log(downloadLink);
            return {
                id: croppedImageAttachment.forAttachmentIdAsString,
                spaceKey: macroUtils.getSpaceKey(),
                fileName: croppedImageAttachment.forTitle,
                contentId: croppedImageAttachment.forContentId,
                index: beforeCropPicture.index,
                when: croppedImageAttachment.forCreationDate,
                mediaType: croppedImageAttachment.forMediaType,
                linkDownload: downloadLink,
                captions: beforeCropPicture.captions,
                copyright: beforeCropPicture.copyright,
                // imageURLHalfSize: "",
                // imageURLQuarterSize: "",
                scaledImageURL: "",
            }
        },
        persistImageSelection: function (attachment, isSave) {
            if (isSave) {
                var picture = $this.getPicture(attachment);
                // get the last picture's index and increment.
                if (GALLERY_IMAGES.length > 0) {
                    picture.index = GALLERY_IMAGES[GALLERY_IMAGES.length - 1].index + 1;
                }
                /* the image uploaded and scaled versions will still be replaced but will no longer be "selected more than once" when
                the user attempts to re-upload an image or uploading an image with the same file name */
                if (!$this.isImagesAttachmentExists(picture, GALLERY_IMAGES)) {
                    GALLERY_IMAGES.push(picture);
                }
            }
            else {
                //filter array and re-map sorting index.
                var sortingIndex = 0;
                GALLERY_IMAGES = GALLERY_IMAGES.filter(function (el, index) {
                    if (el.id != attachment.id) {
                        //re-update sorting index
                        sortingIndex++;
                        el.index = sortingIndex;
                        return true;
                    }
                });
            }
        },
        createDragAndDropForm: function () {
            var $errorHolder = $("#xgme-add-images-errors");

            DROPZONE = new Dropzone("#xgme-add-images", {
                url: macroUtils.getPOSTAttachmentRESTLink(),
                parallelUploads: 1,
                maxFilesize: 10,
                acceptedFiles: ".png,.jpg,.jpeg",
                headers: {
                    "X-Atlassian-Token": "no-check"
                },
                clickable: ['#xgme-add-images-btn'],
                previewsContainer: '.dropzone-previews',
                transformFile: function (file, done) {
                    var fileType = file.type;
                    loadImage(file, function (currentImage, data) {
                        if (data.exif && data.exif.get('Orientation') && data.exif.get('Orientation') > 0) {
                            // Reset Exif Orientation data
                            loadImage.writeExifData(data.imageHead, data, 'Orientation', 1);
                            currentImage.toBlob(function (blob) {
                                loadImage.replaceHead(blob, data.imageHead, function (newBlob) {
                                    done(newBlob);
                                });
                            }, fileType);
                        } else {
                            done(file);
                        }
                    }, {
                        meta: true,
                        orientation: true,
                        canvas: true
                    });
                },
                init: function () {
                    var dropzone = this;
                    this.on("success", function (file, res) {
                        var deferred = new $.Deferred();
                        $this.checkImageUploaded(res.results[0]);
                        $this.updateSelectedImageCount();
                    });
                    this.on("complete", function (file) {
                        this.removeFile(file);
                    });
                    this.on("error", function (file, response) {
                        dropzone.removeAllFiles(true);
                        var message = typeof response == "object" ? response.message : response;
                        if (IS_TEMPLATE_CONTENT) {
                            $errorHolder.html('<div class="aui-message aui-message-error"><p class="title">' +
                              '<strong>Error! Templates Page does not support Attachments.</strong></p></div>');
                        } else {
                            $errorHolder.html('<div class="aui-message aui-message-error"><p class="title">' +
                              '<strong>Error! ' + message + '</strong></p></div>');
                        }

                    });
                }
            });
        },
        scaleGalleryImages: function (galleryName) {
            return $.ajax({
                url: macroUtils.getPOSTScaleGalleryImagesRESTLink(galleryName),
                headers: {
                    "X-Atlassian-Token": "no-check"
                },
                type: 'POST'
            })
                .fail(function (xhr, textStatus, errorThrown) {
                    console.log('Error scaling gallery images of gallery =' + galleryName, textStatus, errorThrown);
                });
        },
        checkImageUploaded: function (imageRes) {
            var attachmentId = imageRes.id;
            var attachmentIdLong = attachmentId.substring(attachmentId.lastIndexOf('t') + 1, attachmentId.length);

            IMAGE_ATTACHMENTS = IMAGE_ATTACHMENTS.filter(function (image) {
                if (image.title == imageRes.title) {
                    $this.removeImageFromList(attachmentIdLong);
                    return false;
                }
                return true;
            });

            $this.appendImageToList(imageRes, attachmentIdLong, null, true);
        },
        appendImagesToList: function (imagesRes) {
            var isScaledImages = function (image) {
                for (var labelsCtr = 0; labelsCtr < image.metadata.labels.results.length; labelsCtr++) {
                    if (image.metadata.labels.results[labelsCtr].name === 'xalt-gallery-scale'
                      || image.metadata.labels.results[labelsCtr].name === 'xalt-gallery-thumbnail'
                      || image.metadata.labels.results[labelsCtr].name === 'len-teaser') {
                        return true;
                    }
                }
                return false;
            };
            imagesRes.map(function (image) {
                // only append image files but not the auto scaled images.
                if (macroUtils.isSupportedImage(image.metadata.mediaType)) {
                    if (!isScaledImages(image)) {
                        var attachmentId = macroUtils.getAttachmentIdFromString(image.id);
                        $this.appendImageToList(image, attachmentId, CURRENT_IMAGE_INDEX, false, null);
                        CURRENT_IMAGE_INDEX++;
                    }
                }
            });
            $this.updateSelectedImageCount();
        },
        appendImageToList: function (imageRes, attachmentId, index, isNewUpload) {
            var imageName = imageRes.title;
            var selected = '';
            var found = GALLERY_IMAGES.some(function (picture) {
                return picture.id == imageRes.id;
            });

            if (found || isNewUpload) {
                selected = 'selected';
            }

            IMAGE_ATTACHMENTS.push(imageRes);

            var imageThumbnailLink = $this.getImageThumbnailLink(imageName, imageRes.version.when);

            //null index - means this got inserted from an upload
            if (index === null) {
                index = IMAGE_ATTACHMENTS.length - 1;
            }

            $(".xgme-add-images-list").prepend(
                '<div class="xgme-add-attached-image" data-attachment-id="' + attachmentId + '">' +
                '<div class="xgme-file-container ' + selected + '" data-image-attachment-index="' + index + '">' +
                '<img class="xgme-file-thumbnail" src="' + imageThumbnailLink + '">' +
                '<i class="xgme-icon select">Select</i>' +
                '</div>' +
                '<span class="xgme-add-image-name">' + imageName + '</span>' +
                '</div>'
            );

            // set which button to show
            $this.checkCurrentSelectedImages();
            if (isNewUpload) { $this.persistImageSelection(IMAGE_ATTACHMENTS[index], true); }
        },
        removeImageFromList: function (attachmentId) {
            $("div[data-attachment-id=" + attachmentId + "]").remove();
        },
        loadImages: function (nextImagesUrl) {
            return $.ajax({
                url: (nextImagesUrl) ? nextImagesUrl : macroUtils.getAttachmentRESTLink(),
                type: 'GET'
            });
        },
        loadAllImages: function (apiUrl, callbackFunction) {
            var requestUrl = macroUtils.getAttachmentRESTLink();

            if (apiUrl !== null) {
                requestUrl = macroUtils.getContextPath() + apiUrl;
            }

            return $this.loadImages(requestUrl).then(function (res) {
                callbackFunction(res.results);
                if (res._links.next !== undefined) { // succeeding iterations of next images
                    $this.loadAllImages(res._links.next, callbackFunction);
                }
            });
        },
        resetAddImages: function () {
            IMAGE_ATTACHMENTS = [];
            $(".xgme-add-images-list").empty();
        },
        sortImagesByName: function (galleryImages) {
            return galleryImages.sort(function (a, b) {
                var imgNameA = a.fileName.toUpperCase();
                var imgNameB = b.fileName.toUpperCase();
                if (imgNameA < imgNameB) {
                    return -1;
                }
                if (imgNameA > imgNameB) {
                    return 1;
                }
                return 0;
            });
        },
        sortImagesBySortingIndex: function (galleryImages) {
            return galleryImages.sort(function (a, b) {
                if (a.index < b.index) {
                    return -1;
                }
                if (a.index > b.index) {
                    return 1;
                }
                return 0;
            });
        },
        appendImagesToSortable: function (imagesRes) {
            $.each(imagesRes, function (i, image) {
                if (macroUtils.isSupportedImage(image.mediaType)) {
                    var attachmentId = macroUtils.getAttachmentIdFromString(image.id);
                    var imageName = image.fileName;

                    var imageThumbnailLink = $this.getImageThumbnailLink(imageName, image.when);

                    $("#xgme-properties-list").append(
                        '<div class="xgme-properties-item xgme-text-center" data-image-array-index="' + i + '" ' +
                        'data-image-sorting-index="' + image.index + '">' +
                        '<div class="col-1-of-3 xgme-properties-item__drag-cell">' +
                        '<div class="xgme-properties-item__sort-icon">' +
                        '<span class="xgme-properties-sorting-label">' + image.index + '</span>' +
                        '<span class="aui-icon aui-icon-small aui-iconfont-menu sorthandle">' +
                        'Menu icon for dragging' +
                        '</span>' +
                        '</div>' +
                        '<div class="xgme-file-container xgme-properties-item__image" ' +
                        'data-attachment-id="' + attachmentId + '">' +
                        '<img class="xgme-file-thumbnail" ' +
                        'src="' + imageThumbnailLink + '" />' +
                        '</div>' +
                        '</div>' +
                        '<div class="col-1-of-3 xgme-properties-item__caption-input">' +
                        '<form class="aui">' +
                        '<div class="field-group">' +
                        '<input class="text medium-field caption-input" type="text" name="caption" ' +
                        'value="' + image.captions.value + '" data-image-array-index="' + i + '">' +
                        '</div>' +
                        '</form>' +
                        '</div>' +
                        '<div class="col-1-of-3 xgme-properties-item__copyright-input">' +
                        '<form class="aui">' +
                        '<div class="field-group">' +
                        '<input class="text medium-field copyright-input" type="text" ' +
                        'name="copyright" value="' + image.copyright + '" ' +
                        'data-image-array-index="' + i + '">' +
                        '</div>' +
                        '</form>' +
                        '</div>' +
                        '</div>'
                    );
                }
            });
        },
        createSortable: function () {
            var propertiesList = document.getElementById('xgme-properties-list');
            Sortable.create(propertiesList, {
                handle: '.sorthandle',
                draggable: ".xgme-properties-item",
                animation: 150,
                onEnd: function (evt) {
                    // var el = $(evt.item);
                    // var oldEl = $('.xgme-properties-item[data-image-sorting-index="'+evt.newIndex+'"]');
                    // oldEl.attr('data-image-sorting-index', evt.oldIndex);
                    // oldEl.find('.xgme-properties-sorting-label').text(evt.oldIndex);
                    //
                    // el.attr('data-image-sorting-index', evt.newIndex);
                    // el.find('.xgme-properties-sorting-label').text(evt.newIndex);

                    //after sorting, changes the index attributes of the images so it follows the sort list
                    var propertiesList = $(".xgme-properties-item");
                    propertiesList.each(function (index) {
                        var sortIndex = index + 1;
                        $(this).attr('data-image-sorting-index', sortIndex);
                        $(this).find('.xgme-properties-sorting-label').text(sortIndex);
                        var galIndex = $(this).attr('data-image-array-index');
                        GALLERY_IMAGES[galIndex].index = sortIndex;
                        $(this).attr('data-image-array-index', index);
                        $(this).find('.copyright-input').attr('data-image-array-index', index);
                        $(this).find('.caption-input').attr('data-image-array-index', index);
                    });
                    //to finalize we also need to re-sort the GALLERY_IMAGES.
                    GALLERY_IMAGES = $this.sortImagesBySortingIndex(GALLERY_IMAGES);

                    SORTING_TYPE = 'custom';
                    $("#gallery-sorting-type").val($this.sortingType.CUSTOM);
                }
            });
        },
        appendImagesToSwiper: function (imagesRes) {
            $.each(imagesRes, function (i, image) {
                //EDIT_IMAGES.push(image);
                if (macroUtils.isSupportedImage(image.mediaType)) {
                    var attachmentId = macroUtils.getAttachmentIdFromString(image.id);
                    var imageName = image.fileName;
                    var imageThumbnailLink = $this.getImageThumbnailLink(imageName, image.when);
                    $(".swiper-wrapper.xgme-edit-swiper-wrapper").append(
                        '<div class="xgme-edit-swiper swiper-slide">' +
                        '<div class="xgme-edit-image" data-attachment-id="' + attachmentId + '">' +
                        '<div class="xgme-file-container">' +
                        '<img class="xgme-file-thumbnail" src="' + imageThumbnailLink + '" />' +
                        '</div>' +
                        '<span class="xgme-edit-image-name">' + imageName + '</span>' +
                        '</div>' +

                        '</div>'
                    );
                }
            });
            //EDIT_IMAGES.reverse();
        },
        createEditSwiper: function () {
            SWIPER = new Swiper('.xgme-edit-swiper-container', {
                slidesPerView: 5,
                spaceBetween: 2,
                slideToClickedSlide: true,
                centeredSlides: true,
                navigation: {
                    nextEl: '.swiper-button-next',
                    prevEl: '.swiper-button-prev'
                }
            });

            ACTIVE_EDIT_IMAGE = GALLERY_IMAGES[0];
            SELECTED_EDIT_SLIDE = $(SWIPER.slides[0]);

            SWIPER.on('slideChange', function () {
                ACTIVE_EDIT_IMAGE = GALLERY_IMAGES[SWIPER.realIndex];
                SELECTED_EDIT_SLIDE = $(SWIPER.slides[SWIPER.realIndex]);
                var image = document.getElementById('xgme-image');
                image.src = macroUtils.getContextPath() + ACTIVE_EDIT_IMAGE.linkDownload;
                $this.destroyCropper();
                $this.initCropper();
                $this.resetFilter();
            });
        },
        resetEdit: function () {
            $(".xgme-edit-swiper-wrapper").empty();
            //EDIT_IMAGES = [];
            $this.destroyCropper();
            $this.resetFilter();
            SELECTED_EDIT_SLIDE;
        },

        destroyCropper: function () {
            if (CROPPER) {
                $this.resetCrop();
                CROPPER.destroy();
                $this.resetEditStack();
            }
        },

        resetEditStack: function () {
            PRE_EDIT_IMAGE = undefined;
            EDITED_IMAGE = undefined;
            REDO = [];
            UNDO = [];
            $(".xgme-edit-undo").attr("disabled", "disabled");
            $(".xgme-edit-redo").attr("disabled", "disabled");
        },

        resetProperties: function () {
            $(".xgme-properties-item").remove();
        },

        initCropper: function () {
            $this.destroyCropper()
            var image = document.getElementById('xgme-image');
            var activeEditImage = GALLERY_IMAGES[SWIPER.realIndex];

            //image.setAttribute('src', macroUtils.getContextPath()+initEditImage._links.download);
            image.src = macroUtils.getContextPath() + activeEditImage.linkDownload;
            CROPPER = new Cropper(image, {
                viewMode: 2,
                cropBoxResizable: true,
                dragMode: 'none',
                autoCrop: false,
                autoCropArea: 1,
                precisePreview: true,
                ready: function () {
                    $(".xgme-edit-tools").show();

                    if (!PRE_EDIT_IMAGE) {
                        PRE_EDIT_IMAGE = CROPPER.getCroppedCanvas();
                    }

                    UNDO.push(CROPPER.getCroppedCanvas());
                    if (UNDO.length > 1) {
                        $(".xgme-edit-undo").removeAttr("disabled");
                        $(".xgme-edit-reset").removeAttr("disabled");
                    } else {
                        $(".xgme-edit-undo").attr("disabled", "disabled");
                        $(".xgme-edit-reset").attr("disabled", "disabled");

                    }

                    if (REDO_UNDO_TRIGGERED) {
                        REDO_UNDO_TRIGGERED = false;
                    } else {
                        REDO = [];
                    }

                    if (REDO.length > 0) {
                        $(".xgme-edit-redo").removeAttr("disabled");
                    } else {
                        $(".xgme-edit-redo").attr("disabled", "disabled");
                    }

                }
            });
        },
        saveEditedImage: function () {
            var dfd = new $.Deferred();
            var croppedImage = CROPPER.getData();

            var galleryName = '';
            if (E_GALLERY) galleryName = E_GALLERY.name;

            // call crop API with file from the canvass
            CROPPER.getCroppedCanvas().toBlob(function (blob) {
                const formData = new FormData();
                formData.append('croppedImage', blob, ACTIVE_EDIT_IMAGE.fileName);
                $.ajax({
                    url: macroUtils.getPOSTCropImageV2RESTLink(ACTIVE_EDIT_IMAGE.fileName, galleryName),
                    type: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    headers: {
                        "X-Atlassian-Token": "no-check"
                    }
                }).done(function (res) {
                    dfd.resolve(res);
                }).fail(function (xhr, textStatus, errorThrown) {
                    AJS.error('Error saving edited image=' + ACTIVE_EDIT_IMAGE.id, textStatus, errorThrown);
                    dfd.reject();
                });
            }, ACTIVE_EDIT_IMAGE.mediaType);

            return dfd.promise();
        },
        updateEditTabElements: function (editedImageRes) {
            $(".xgme-edit-tools").hide();
            ACTIVE_EDIT_IMAGE = $this.getUpdatedPicture(editedImageRes, ACTIVE_EDIT_IMAGE);
            $this.resetEditor();
            CROPPER.destroy();
            this.initCropper();

            // CROPPER.replace(macroUtils.getContextPath()+ACTIVE_EDIT_IMAGE._links.download);

            //update the image on the EDIT_IMAGE
            GALLERY_IMAGES[SWIPER.realIndex] = ACTIVE_EDIT_IMAGE;
            //update the slide
            SELECTED_EDIT_SLIDE.find("xgme-edit-image").attr('data-attachment-id',
                macroUtils.getAttachmentIdFromString(ACTIVE_EDIT_IMAGE.id));
            SELECTED_EDIT_SLIDE.find("img").attr('src', macroUtils.getThumbnailLink(ACTIVE_EDIT_IMAGE.fileName,
                ACTIVE_EDIT_IMAGE.when));
        },
        getDisplayImageURL: function (image) {
            var imageURL;
            if (image.scaledImageURL && image.scaledImageURL !== "") {
                imageURL = image.scaledImageURL;
            } else {
                imageURL = macroUtils.getContextPath() + image.linkDownload;
            }
            return imageURL;
        },
        getImageSrcSet: function (image) {
            var imageSrcSet;
            if (image.scaled2xImageURL && image.scaled2xImageURL !== "") {
                imageSrcSet = image.scaled2xImageURL + " 2x";
            }
            return imageSrcSet;
        },
        appendImagesToPreviewMasonry: function (images) {
            $(".xgme-preview-masonry").append('<div class="xgm-masonry-sizer"></div>');
            $.each(images, function (i, image) {
                i += 1;
                if (macroUtils.isSupportedImage(image.mediaType)) {
                    var imageURL = $this.getDisplayImageURL(image);
                    var imageSrcSet = $this.getImageSrcSet(image);
                    $(".xgme-preview-masonry").append(
                        '<div class="xgm-masonry-item"> ' +
                        (!!image.copyright || !!image.captions.value ?
                            '<div class="xgm-masonry-item-overlay">' :
                            '<div class="xgm-masonry-item-overlay" style="padding:0">') +
                        '<div class="xgme-preview-caption">' + image.captions.value + '</div>' +
                        (GALLERY_SETTINGS.showCopyright && !!(image.copyright.trim()) ?
                            '<div class="slideshow-footer__copyright">&copy; ' + image.copyright + '</div>' : '') +
                        '</div>' +
                        '<img src="' + imageURL + '" ' +
                        'class="xgm-masonry-image x-modal-img" ' +
                        (imageSrcSet ? 'srcset="' + imageSrcSet + '"' : '') + '/> ' +
                        '</div>');
                }
            });
        },
        appendImagesToPreviewGrid: function (imagesRes) {
            $(".xgme-preview-grid").append('<div class="xgm-grid-sizer"></div>');
            $.each(imagesRes, function (i, image) {
                if (macroUtils.isSupportedImage(image.mediaType)) {
                    var attachmentId = macroUtils.getAttachmentIdFromString(image.id);
                    var imageName = image.fileName;
                    var imageURL = $this.getDisplayImageURL(image);
                    var imageSrcSet = $this.getImageSrcSet(image);
                    $(".xgme-preview-grid").append(
                        '<div class="xgm-grid-item">' +

                        (!!image.copyright || !!image.captions.value ?
                            '<div class="xgm-grid-item-overlay">' :
                            '<div class="xgm-grid-item-overlay" style="padding:0">') +
                        '<div class="xgme-preview-caption">' + image.captions.value + '</div>' +
                        (GALLERY_SETTINGS.showCopyright && !!(image.copyright.trim()) ?
                            '<div class="slideshow-footer__copyright">&copy; ' + image.copyright + '</div>' : '') +
                        '</div>' +

                        '<img src="' + imageURL + '" ' +
                        'class="xgm-grid-image"' + (imageSrcSet ? 'srcset="' + imageSrcSet + '"' : '') + '/> ' +
                        '</div>');
                }
            });
        },
        appendImagesToPreviewSwiper: function (imagesRes) {
            $.each(imagesRes, function (i, image) {
                if (macroUtils.isSupportedImage(image.mediaType)) {
                    var attachmentId = macroUtils.getAttachmentIdFromString(image.id);
                    var imageURL = $this.getDisplayImageURL(image);
                    var imageSrcSet = $this.getImageSrcSet(image);
                    $(".swiper-wrapper.xgme-preview-swiper-wrapper").append(
                        '<div class="xgme-preview-swiper swiper-slide">' +
                        '<div class="xgme-preview-image" data-attachment-id="' + attachmentId + '">' +
                        '<img src="' + imageURL + '"' + (imageSrcSet ? 'srcset="' + imageSrcSet + '"' : '') + '/> ' +
                        '<div class="xgme-preview-caption">' + image.captions.value + '</div>' +
                        (GALLERY_SETTINGS.showCopyright && !!(image.copyright.trim()) ?
                            '<div class="xgme-preview-copyright">&copy; ' + image.copyright + '</div>' : '') +
                        '</div>' +
                        '</div>'
                    );
                }
            });
        },
        updateMasonryCss: function (numberOfImages) {
            if (numberOfImages < 4) {
                if (numberOfImages == 2) {
                    $('.xgm-masonry-sizer,.xgm-masonry-item').css('width', '50%');
                    return;
                } else if (numberOfImages == 1) {
                    $('.xgm-masonry-sizer,.xgm-masonry-item').css('width', '100%');
                    return;
                }
                // for 3 images
                $('.xgm-masonry-sizer,.xgm-masonry-item').css('width', '30%');
            }
        },
        initPreviewMasonry: function () {
            // init Masonry
            MASONRY_GRID = $('.xgme-preview-masonry').imagesLoaded(function () {
                // init Masonry after all images have loaded
                MASONRY_GRID.masonry({
                    // options...
                    itemSelector: '.xgm-masonry-item',
                    columnWidth: '.xgm-masonry-sizer',
                    percentPosition: true
                });
            });
        },
        createPreviewSwiper: function () {
            PREV_SWIPER = new Swiper('.xgme-preview-swiper-container', {
                navigation: {
                    nextEl: '.swiper-button-next',
                    prevEl: '.swiper-button-prev'
                },
                pagination: {
                    el: '.xgme-preview-swiper-pagination',
                    dynamicBullets: true,
                }
            });
        },
        resetPreview: function () {
            $(".xgme-preview-swiper-wrapper").empty();
            $(".xgme-preview").hide();
            $(".xgme-preview-grid").empty();
            $(".xgme-preview-grid").hide();
            $(".xgme-preview-masonry").empty();
            $(".xgme-preview-masonry").hide();
            if (PREV_SWIPER) PREV_SWIPER.destroy(true, true);
            if (MASONRY_GRID) MASONRY_GRID.masonry('destroy');
        },
        checkForActiveFlags: function () {
            //checks if there are already exising aui flag that is active.
            //this is to prevent multiple flags for showing up.
            var val = false;
            var flags = $('.aui-flag');
            $.each(flags, function (i, flag) {
                var $flag = $(flag);
                if ($flag.attr('aria-hidden') === 'false') {
                    val = true;
                    return false;
                }
            })
            return val;
        },
        initSortableListeners: function () {
            $(".caption-input").prop('maxLength', MAX_CAPTION_LENGTH);
            $(".copyright-input").prop('maxLength', MAX_COPYRIGHT_LENGTH);

            $(".copyright-input").on('keyup', function () {
                var galIndex = $(this).attr('data-image-array-index');
                GALLERY_IMAGES[galIndex].copyright = $(this).val();

                if ($(this).val().length === MAX_COPYRIGHT_LENGTH) {
                    var isFlagAlreadyShowed = $this.checkForActiveFlags();
                    if (!isFlagAlreadyShowed) {
                        //give an info to the user.
                        AJS.flag({
                            type: 'info', body: 'Max Copyright Reached. (' + MAX_COPYRIGHT_LENGTH + ') characters.',
                            close: 'auto'
                        });
                    }
                }
            });

            $(".caption-input").on('keyup', function (e) {
                var galIndex = $(this).attr('data-image-array-index');
                GALLERY_IMAGES[galIndex].captions.value = $(this).val();

                if ($(this).val().length === MAX_CAPTION_LENGTH) {
                    var isFlagAlreadyShowed = $this.checkForActiveFlags();
                    if (!isFlagAlreadyShowed) {
                        //give an info to the user.
                        AJS.flag({
                            type: 'info', body: 'Max Caption Reached. (' + MAX_CAPTION_LENGTH + ') characters.',
                            close: 'auto'
                        });
                    }
                }
            });

            $("#gallery-sorting-type").on('change', function () {
                SORTING_TYPE = $(this).val();
                $this.resetProperties();
                $this.initGallerySorting();
                $this.appendImagesToSortable(GALLERY_IMAGES);
                $this.createSortable();
            });
        },
        initGallerySorting: function () {
            if (SORTING_TYPE == $this.sortingType.NAME) {
                GALLERY_IMAGES = $this.sortImagesByName(GALLERY_IMAGES);
                GALLERY_IMAGES.map(function (image, i) {
                    image.index = i + 1;
                })
                $("#gallery-sorting-type").val($this.sortingType.NAME);
            }
            else {
                $("#gallery-sorting-type").val($this.sortingType.CUSTOM);
            }
        },
        initTab: function (tabContentId) {
            $('.xgme-body').removeClass('xgme-body-settings-overflow'); // makes sure there is no overflow class in body
            if (tabContentId === $this.tabContent.ADD) {
                if (DROPZONE === undefined) $this.createDragAndDropForm();
                $this.resetAddImages();
                CURRENT_IMAGE_INDEX = 0;
                if (!IS_TEMPLATE_CONTENT) {
                    $this.loadAllImages(null, $this.appendImagesToList);
                }
                $this.addSelectAllImagesFunction();
            }
            else if (tabContentId === $this.tabContent.PROPERTIES) {
                $this.resetProperties();
                $this.initGallerySorting();
                $this.appendImagesToSortable(GALLERY_IMAGES);
                $this.createSortable();
                $this.initSortableListeners();
            }
            else if (tabContentId === $this.tabContent.EDIT) {
                $this.resetEdit();
                if (GALLERY_IMAGES.length > 0) {
                    $("#xgme-edit").show();
                    $("#xgme-edit-no-pictures").hide();

                    $this.appendImagesToSwiper(GALLERY_IMAGES);
                    $this.createEditSwiper();
                    $this.initCropper();
                }
                else {
                    $("#xgme-edit").hide();
                    $("#xgme-edit-no-pictures").show();
                }
            }
            else if (tabContentId === $this.tabContent.PREVIEW) {
                $this.resetPreview();
                if (GALLERY_IMAGES.length > 0) {
                    $("#xgme-preview-no-pictures").hide();

                    if (GALLERY_SETTINGS.displayType === macroUtils.displayType.SLIDESHOW) {
                        $(".xgme-preview").show();
                        $this.appendImagesToPreviewSwiper(GALLERY_IMAGES);
                        $this.createPreviewSwiper();
                    }
                    else if (GALLERY_SETTINGS.displayType === macroUtils.displayType.GRID) {
                        $(".xgme-preview-grid").css('display', 'flex');
                        $this.appendImagesToPreviewGrid(GALLERY_IMAGES);
                    } else {
                        $('.xgme-preview-masonry').show();
                        $this.appendImagesToPreviewMasonry(GALLERY_IMAGES);
                        $this.updateMasonryCss(GALLERY_IMAGES.length);
                        $this.initPreviewMasonry();
                    }

                }
                else {
                    $(".xgme-preview").hide();
                    $("#xgme-preview-no-pictures").show();
                }
            }
            else if (tabContentId === $this.tabContent.SETTINGS) {
                $("#gallery-dimension").val(GALLERY_SETTINGS.gallerySize);
                $("#display-type").val(GALLERY_SETTINGS.displayType);
                if (GALLERY_SETTINGS.showCopyright) {
                    $("#display-copyright").prop('checked', true);
                }
                if (GALLERY_SETTINGS.displayPlainInMobile) {
                    $('#display-plain-images-in-mobile').prop('checked', true);
                }
                $this.initSettingsListeners();
                $('.xgme-body').addClass('xgme-body-settings-overflow'); // overflow-x scroll when the window is not wide enough
            }
        },
        initSettingsListeners: function () {

            $("#display-copyright").change(function () {
                if (this.checked) {
                    GALLERY_SETTINGS.showCopyright = true;
                }
                else {
                    GALLERY_SETTINGS.showCopyright = false;
                }
            });

            $('#display-plain-images-in-mobile').change(function () {
                if (this.checked) {
                    GALLERY_SETTINGS.displayPlainInMobile = true;
                }
                else {
                    GALLERY_SETTINGS.displayPlainInMobile = false;
                }
            });

            $('input[type=radio][name=xgme-display-type]').change(function () {
                GALLERY_SETTINGS.displayType = this.value;
            });

            $("#gallery-dimension").change(function () {
                var dimension = $(this).val();
                if (dimension.includes('x')) {
                    var dimensionArr = dimension.split("x");
                    $("#gallery-width").val(dimensionArr[0]);
                    $("#gallery-height").val(dimensionArr[1]);

                    GALLERY_SETTINGS.galleryWidth = dimensionArr[0];
                    GALLERY_SETTINGS.galleryHeight = dimensionArr[1];
                } else {
                    GALLERY_SETTINGS.gallerySize = dimension;
                }
            });
        },
        loadGalleryData: function (galleryName) {
            var url = macroUtils.getGalleryRESTLink() + '/' + encodeURIComponent(galleryName) + '?pageId=' + macroUtils.getPageId();
            return $.ajax({
                url: url,
                type: 'GET',
                dataType: 'json'
            })
                .fail(function (xhr, textStatus, errorThrown) {
                    console.log('Error getting gallery =' + galleryName, textStatus, errorThrown);
                });
        },
        applyGalleryRestrictions: function (currentTab) {
            $(".xgme-gallery-restriction-msg").removeClass("hidden");
            $('.xgme-menu-item').addClass("hidden");
            $('.xgme-navigation').addClass("hidden");
            $('.xgme-save-maro-btn').addClass("hidden");

            currentTab.removeClass("current");
            currentTab = $("#" + $this.tabContent.RESTRICTED);
            currentTab.addClass("current");
        },
        applyGalleryOriginRestrictions: function (currentTab) {
            IS_GALLERY_ORIGIN = false;
            $this.applyGalleryRestrictions(currentTab);

        },
        applyExpiredLicenseRestrictions: function (currentTab) {
            IS_LICENSE_OK = false;
            $this.applyGalleryRestrictions(currentTab);
        },
        isWidthTwiceTheHeight: function (width, height) {
            if ((height * 2) <= width) {
                return true;
            } else {
                return false;
            }
        },
        addSelectAllImagesFunction: function () {
            $('#xgme-select-all-images-btn').on('click', function () {
                $('#xgme-body-add .xgme-file-container').each(function () {
                    var currentImageHasClass = $(this).hasClass('selected');
                    if (!currentImageHasClass) {
                        var imgAttachmentIndex = $(this).attr("data-image-attachment-index");
                        if (imgAttachmentIndex) {
                            $(this).addClass("selected");
                            $this.persistImageSelection(IMAGE_ATTACHMENTS[imgAttachmentIndex], true);
                        }
                    }
                });
                if ($('#xgme-body-add .xgme-file-container').length > 0) { // to prevent changing to unselect all when clicked when no images available
                    $this.checkCurrentSelectedImages();
                }
                $this.updateSelectedImageCount();
            });

            $('#xgme-unselect-all-images-btn').on('click', function () {
                $('#xgme-body-add .xgme-file-container').each(function () {
                    var currentImageHasClass = $(this).hasClass('selected');
                    if (currentImageHasClass) {
                        var imgAttachmentIndex = $(this).attr("data-image-attachment-index");
                        if (imgAttachmentIndex) {
                            $(this).removeClass("selected");
                            $this.persistImageSelection(IMAGE_ATTACHMENTS[imgAttachmentIndex], false);
                        }
                    }
                });
                $this.checkCurrentSelectedImages();
                $this.updateSelectedImageCount();
            });
        },
        checkCurrentSelectedImages: function () {
            var fileAttachmentsCount = $('#xgme-body-add .xgme-file-container').length;
            var selectedFileAttachmentsCount = $('#xgme-body-add .xgme-file-container.selected').length;

            if (fileAttachmentsCount === selectedFileAttachmentsCount) {
                $('#xgme-select-all-images-btn').hide();
                $('#xgme-unselect-all-images-btn').show();
            } else {
                $('#xgme-unselect-all-images-btn').hide();
                $('#xgme-select-all-images-btn').show();
            }
        },
        updateSelectedImageCount: function () {
            var currentCount = $('div.xgme-file-container.selected').length;
            var countSpan = $('#xgme-selected-image-count');
            if (currentCount >= 1) {
                countSpan.text(currentCount + ' items selected');
            } else {
                countSpan.text('0 items selected');
            }
        },
        isScaledImages: function (image) {
            if (image.metadata.labels) { // check if the attachment has label. most dropzoned images don't.
                for (var labelsCtr = 0; labelsCtr < image.metadata.labels.results.length; labelsCtr++) {
                    if (image.metadata.labels.results[labelsCtr].name === 'xalt-gallery-scale') {
                        return true;
                    }
                }
            }
            return false;
        },
        getImageThumbnailLink: function (imageName, imageWhen) {
            var imageThumbnailLink = macroUtils.getThumbnailLink(imageName, imageWhen);

            if (CURRENT_THUMBNAIL_LINKS[imageName]) {
                imageThumbnailLink = CURRENT_THUMBNAIL_LINKS[imageName];
            }

            return imageThumbnailLink;
        },

        resetCrop: function () {
            //resets the statuses of the crop edit functions
            CROPPER.setAspectRatio(NaN);
            CROPPER.autoCropArea = 1;
            CROPPER.zoomable = false;

            $(".xgme-edit-crop-square").removeClass("down");
            $(".xgme-edit-crop-buttons").addClass("invisible");
            $(".xgme-edit-buttons").removeAttr("disabled");
            $(".xgme-edit-crop-container").removeClass("down");
            $(".xgme-edit-crop").removeClass("down");
            $(".xgme-ratio-buttons").removeClass("down");
        },

        resetFilter: function () {
            $(".xgme-edit-container").show();
            $(".xgme-filter-image-container").hide();
            $(".xgme-edit-images-list").show();
            $(".xgme-edit-buttons").not($(".xgme-filter-buttons")).removeAttr("disabled", "disabled");
            $(".xgme-edit-filter-container").addClass("invisible");
            $(".xgme-presets-container").addClass("invisible");
        },

        resetEditor: function () {
            $this.resetCrop();
            $this.resetFilter();
        },

        isImagesAttachmentExists: function (image, images) {
            for (var i = 0; i < images.length; i++) {
                var currentImage = images[i];
                if (currentImage.fileName === image.fileName) {
                    return true;
                }
            }
            return false;
        },
    };

    return {
        initEditor: function (isNew, macroParamGalleryName) {
            var xgmeMenuItemClass = "xgme-menu-item";
            var currentTabContent = $(".xgme-loadcontent.current");

            var dfd = $.Deferred();

            var isLicenseOk = $(".xgme-is-license-expired").val();

            if (isLicenseOk === "false") {
                $this.applyExpiredLicenseRestrictions(currentTabContent);
                dfd.resolve();
            }
            else {
                if (!isNew) {
                    $this.loadGalleryData(macroParamGalleryName).then(function (res) {
                        E_GALLERY = res;
                        if (E_GALLERY.pageId !== macroUtils.getPageId()) {
                            $this.applyGalleryOriginRestrictions(currentTabContent);
                        }
                        else {
                            GALLERY_IMAGES = E_GALLERY.pictures;
                            SORTING_TYPE = E_GALLERY.sortingType;
                            GALLERY_SETTINGS = $this.getGallerySettings(E_GALLERY, false);

                            $('#xgme-displaytype-' + GALLERY_SETTINGS.displayType).prop('checked', true);

                            currentTabContent = showInitTab(currentTabContent);
                        }

                        dfd.resolve();
                    });
                }
                else {
                    SORTING_TYPE = $this.sortingType.NAME;
                    GALLERY_SETTINGS = $this.getGallerySettings(null, true);
                    currentTabContent = showInitTab(currentTabContent);
                    dfd.resolve();
                }
            }

            /*register listeners*/

            //menu select functionality
            $("." + xgmeMenuItemClass).click(function (e) {

                //remove prevent default if changed to a button
                e.preventDefault();

                var currentTabOrder = $(".xgme-menu-item.current").attr('data-body-order');
                var nextTabOrder = $(this).attr('data-body-order');

                //remove current class to the tab menu
                $("." + xgmeMenuItemClass).parent().removeClass("current");
                $("." + xgmeMenuItemClass).parent().removeClass("aui-class-selected");
                //add current class to this
                $(this).parent().addClass("current");
                $(this).parent().addClass("aui-class-selected");

                var xgmeTabContentId = $(this).attr('data-body-target');

                // remove and add classes to tab content
                var direction;
                var nextTabContent = $("#" + xgmeTabContentId);
                direction = nextTabOrder - currentTabOrder > -1 ? "right" : "left";
                updateCurrentTabClass(currentTabContent, nextTabContent, direction);

                currentTabContent = nextTabContent;

                $this.initTab(xgmeTabContentId);
            });

            $(".xgme-add-images-list").on('click', 'div.xgme-file-container', function () {
                var imgAttachmentIndex = $(this).attr("data-image-attachment-index");

                if ($(this).hasClass("selected")) {
                    $(this).removeClass("selected");
                    $this.persistImageSelection(IMAGE_ATTACHMENTS[imgAttachmentIndex], false);
                }
                else {
                    $(this).addClass("selected");
                    $this.persistImageSelection(IMAGE_ATTACHMENTS[imgAttachmentIndex], true);
                }
                $this.checkCurrentSelectedImages();
                $this.updateSelectedImageCount();
            });

            $("#editGallerySettings").click(function () {
                if ($(this).is(':checked')) {
                    //$( "#gallery-width" ).prop( "disabled", false );
                    //$( "#gallery-height" ).prop( "disabled", false );
                    $("#gallery-dimension").prop("disabled", false);
                    $("#display-copyright").prop("disabled", false);
                    $("#thumbnal-percentage").prop("disabled", false);
                    $('#display-plain-images-in-mobile').prop("disabled", false);
                } else {
                    //$( "#gallery-width" ).prop( "disabled", true );
                    //$( "#gallery-height" ).prop( "disabled", true );
                    $("#gallery-dimension").prop("disabled", true);
                    $("#display-copyright").prop("disabled", true);
                    $("#thumbnal-percentage").prop("disabled", true);
                    $('#display-plain-images-in-mobile').prop("disabled", true);
                }
            });

            //navigation arrows functionality
            var tabContents = document.querySelectorAll('.xgme-tabcontent');
            var currentId;
            var navCurrentTabContentId;

            /* Navigation Event Listeners */
            $('#xgme-nav-prev').on('click', function () {
                /* selectedId corresponds to the tab that WILL be active. It is minus 1 the current Id, because this is the previous arrow */
                var selectedId = getCurrentTab();
                selectedId -= (selectedId == 0) ? 0 : 1;
                navClick(selectedId, "left");
            });

            $('#xgme-nav-next').on('click', function () {

                var selectedId = getCurrentTab() + 1;
                navClick(selectedId, "right");
            });

            $("#xgme-edit-save-crop-btn").click(function () {
                AJS.$('.button-spinner').spin();
                $this.saveEditedImage().then(function (res) {
                    $this.resetEditor();
                    AJS.$('.button-spinner').spinStop();
                    AJS.flag({ type: 'success', body: 'Changes Saved.', close: 'auto' });
                    $this.updateEditTabElements(res);
                });
            });

            AJS.$(".xgme-edit-buttons").tooltip({ gravity: 's' });
            AJS.$(".xgme-edit-control-buttons").tooltip({ gravity: 's' });

            $(".xgme-edit-rotate-left").click(() => rotate(-90));

            $(".xgme-edit-rotate-right").click(() => rotate(90));

            $(".xgme-edit-crop").click(toggleCrop);
            $(".xgme-edit-crop-exit").click(toggleCrop);
            $(".xgme-filter-presets").click(() => {
                $(".xgme-presets-container").removeClass("invisible");
                showFilterEditor();
            }
            );

            $(".xgme-filter-adjustments").click(() => {
                showAdjustmentEditor();
            });

            function showAdjustmentEditor() {
                $(".xgme-presets-container").addClass("invisible");
                $(".xgme-filter-presets").removeClass("down");
                $(".xgme-adjustments-container").toggleClass("invisible");
                $(".xgme-filter-adjustments").addClass("down");
            }

            function resetAdjustments() {
                $(".brightness-value").html("0");
                $(".contrast-value").html("0");
                $(".saturation-value").html("0");
                $(".xgme-adjustments-brightness").val("0");
                $(".xgme-adjustments-contrast").val("0");
                $(".xgme-adjustments-saturation").val("0");
                setFilterVars();
            }

            $(".xgme-adjustments-brightness").on('input', () => {
                var brightness = $(".xgme-adjustments-brightness").val();
                $(".brightness-value").html(brightness);
                FILTER_VARS["brightness"] = brightness/100;
                applyAllFilter();
            });

            $(".xgme-adjustments-contrast").on('input', () => {
                var contrast = $(".xgme-adjustments-contrast").val();
                $(".contrast-value").html(contrast);
                FILTER_VARS["contrast"] = contrast/100;
                applyAllFilter();
            });

            $(".xgme-adjustments-saturation").on('input', () => {
                var saturation = $(".xgme-adjustments-saturation").val();
                $(".saturation-value").html(saturation);
                FILTER_VARS["saturation"] = (saturation/100)*2;
                applyAllFilter();
            });


            function applyAllFilter(){
                FILTEROUS.importImage(FILTER_IMG_OBJ)
                .applyFilter('brightness', FILTER_VARS["brightness"])
                .applyFilter('contrast', FILTER_VARS["contrast"])
                .applyFilter('saturation', FILTER_VARS["saturation"])
                .applyInstaFilter(FILTER_VARS["filter"])
                .renderHtml(FILTER_IMAGE.get(0));;
            }



            function showFilterEditor() {

                $(".xgme-adjustments-container").addClass("invisible");
                $(".xgme-filter-adjustments").removeClass("down");
                $(".xgme-filter-presets").addClass("down");
                
                var presets = $(".xgme-presets-container").find("img");
                var temp_images = [];
                console.log(presets.length);
                for (i = 0; i < presets.length; i++) {
                    var temp_img = new Image();
                    temp_images[i] = temp_img;

                    temp_img.onload = function () {
                        current_index = this.dataset.index;
                        filterous.importImage(temp_images[current_index], { scale: 0.1 }).applyInstaFilter(presets[current_index].title).renderHtml(presets.get(current_index));
                        temp_img.dataset.loaded = true;

                        //maybe for tutorial
                        /* if (parseInt(this.dataset.index) + 1 == presets.length) {
                            $('.xgme-presets-container').animate({ scrollLeft: "156px" }, 800);
                            $('.xgme-presets-container').animate({ scrollLeft: "0px" }, 800);
                        } */

                    };
                    temp_img.dataset.index = i;
                    temp_img.src = FILTER_IMAGE.attr("src");
                    var containerHeight = $(".xgme-presets-container").height();
                    var figureHeight = $(".xgme-filter-figure").height();

                    $(".xgme-presets-container").children().eq(i).width(containerHeight * 0.9);
                    $(".xgme-filter-figure").children("img").eq(i).width(figureHeight * 0.9);

                }
            }

            $(".xgme-edit-filter").click(() => {
                //build scaled filter image
                if (!($("xgme-drop-down-buttons").css("display") == "none")) {
                    FILTER_IMAGE = $('.xgme-filter-image');
                    FILTER_IMAGE.attr("src", CROPPER.getCroppedCanvas().toDataURL("image/jpeg"));
                    FILTER_IMG_OBJ = new Image();
                    FILTER_IMG_OBJ.onload = function () {
                        var scaleFactor = calcScaleFactor(FILTER_IMG_OBJ);
                        FILTEROUS = filterous.importImage(FILTER_IMG_OBJ, { scale: scaleFactor }).renderHtml(FILTER_IMAGE.get(0));
                        toggleFilter();
                    }
                    FILTER_IMG_OBJ.src = CROPPER.getCroppedCanvas().toDataURL("image/jpeg");
                }
                resetAdjustments();
            });

            function calcScaleFactor(currentImage){
                var scaleFactor = 1;
                if (currentImage.width > 1000 || currentImage.height > 1000)
                    {scaleFactor = 1000 / Math.max(currentImage.width, currentImage.height);}

                return scaleFactor;
            }

            $(".xgme-presets-container").children().click(function (event) {
                var preset = $(this).children("img").attr('title');
                FILTER_VARS["filter"] = preset;
                applyAllFilter();
            });

            $(".xgme-filter-apply").click(()=>{
                var img1 = new Image();
                var img2 = new Image()
                //img2.src = CROPPER.getCroppedCanvas().toDataURL("image/jpeg");
                img1.onload = function () {
                    filterous.importImage(img1)
                    .applyFilter('brightness', FILTER_VARS["brightness"])
                    .applyFilter('contrast', FILTER_VARS["contrast"])
                    .applyFilter('saturation', FILTER_VARS["saturation"])
                    .applyInstaFilter(FILTER_VARS["filter"])
                    .renderHtml(img2);
                }

                img2.onload = function () {
                    console.log(img2.src);
                    CROPPER.replace(img2.src);
                    toggleFilter();
                    resetAdjustments();
                }
                img1.src =  CROPPER.getCroppedCanvas().toDataURL("image/jpeg");  
            });

            $(".xgme-filter-exit").click(()=>{
                toggleFilter();
                resetAdjustments();
            });


            function setFilterVars(){
                FILTER_VARS["brightness"] = 0;
                FILTER_VARS["contrast"] = 0
                FILTER_VARS["saturation"] = 0
                FILTER_VARS["filter"] = "normal";

            }

            function toggleFilter() {

                $(".xgme-edit-container").toggle();

                if ($(".xgme-filter-image-container").css("display") == "none")
                    {$(".xgme-filter-image-container").css("display", "flex");}
                else
                    {$(".xgme-filter-image-container").css("display", "none");}

                $(".xgme-edit-images-list").toggle();
                toggleAttr($(".xgme-edit-buttons").not($(".xgme-filter-buttons")), "disabled", "disabled");

                toggleAttr($(".xgme-edit-apply-button"), "disabled", "disabled");
                toggleAttr($(".xgme-edit-control-buttons"), "original-title", "Press ✓ below to apply filters");

                $(".xgme-edit-filter-container").toggleClass("invisible");
                $(".xgme-presets-container").toggleClass("invisible");

                if (!($(".xgme-edit-filter-container").hasClass("invisible")))
                    {showFilterEditor();}
                else 
                    {$(".xgme-presets-container").addClass("invisible");}
            }


            $(".xgme-edit-reset").click(() => {
                EDITED_IMAGE = CROPPER.getCroppedCanvas();
                preImage = PRE_EDIT_IMAGE.toDataURL("image/jpeg");
                CROPPER.replace(preImage);
                $this.resetEditStack();
            });

            $(".xgme-edit-undo").click(() => {
                REDO_UNDO_TRIGGERED = true;
                if (UNDO) {
                    REDO.push(CROPPER.getCroppedCanvas());

                    UNDO.pop();
                    undo = UNDO.pop();

                    CROPPER.replace(undo.toDataURL("image/jpeg"));
                }
            });


            $(".xgme-edit-redo").click(() => {
                REDO_UNDO_TRIGGERED = true;
                if (REDO) {
                    redo = REDO.pop().toDataURL("image/jpeg");
                    CROPPER.replace(redo);
                }
            });

            $(".xgme-edit-crop-apply").click(function () {
                var cropped = CROPPER.getCroppedCanvas().toDataURL("image/jpeg");
                CROPPER.replace(cropped);
                $this.resetCrop();

            });

            $(".xgme-edit-mirror").click(mirror);

            $(".xgme-ratio-buttons").click(function (event) {
                var ratio = $(this).val().split(':');
                setRatio(ratio, $(this));
            });




            function rotate(degree) {

                CROPPER.rotate(degree);
                CROPPER.zoomTo(0);
                var newCropper = CROPPER.getCroppedCanvas().toDataURL("image/jpeg");
                CROPPER.replace(newCropper);
                const containerData = CROPPER.getContainerData();
                const imageData = CROPPER.getCanvasData();
                CROPPER.moveTo((containerData.width - imageData.width) / 2, (containerData.height - imageData.height) / 2);
            }

            //starts and stops cropping. Crop-buttons are made visible
            function toggleCrop() {

                $(".xgme-edit-crop-buttons").toggleClass("invisible");
                $(".xgme-crop-divider").toggleClass("invisible");

                //All edit-buttons not for cropping are dis-/enabled
                if ($(".xgme-edit-crop").hasClass("down")) {
                    CROPPER.clear();
                    $this.resetCrop();
                } else {
                    CROPPER.crop();
                    $(".xgme-edit-buttons").not(".xgme-crop-button").attr("disabled", "disabled");
                    $(".xgme-edit-crop").addClass("down");
                    $(".xgme-edit-crop-container").addClass("down");
                    //$(".xgme-crop-buttons").removeAttr("disabled");
                }
            }


            function mirror() {
                if ($(this).hasClass("xgme-mirror-vertical")) {
                    CROPPER.scaleY(-1);
                } else {
                    CROPPER.scaleX(-1);
                }

                var mirrored = CROPPER.getCroppedCanvas().toDataURL("image/jpeg");
                CROPPER.replace(mirrored);
            }

            function setRatio(ratio, button) {
                if (button.hasClass("down")) {
                    CROPPER.setAspectRatio(NaN);
                } else {
                    CROPPER.setAspectRatio(ratio[0] / ratio[1]);
                }
                $(".xgme-ratio-buttons").not(button).removeClass("down");
                button.toggleClass("down");

            }

            function toggleAttr(jqueryElement, attr, value) {
                if (jqueryElement.attr(attr))
                    jqueryElement.removeAttr(attr);
                else
                    jqueryElement.attr(attr, value);
            }

            function showInitTab(currentTab) {
                currentTab.removeClass("current");
                currentTab = $("#" + $this.tabContent.ADD);
                currentTab.addClass("current");

                $this.initTab($this.tabContent.ADD);

                return currentTab;
            }

            /* get active tab id for reference */
            function getCurrentTab() {
                $.each(tabContents, function (index, item) {
                    if (item.classList.contains('current')) {
                        /* check each element to see if it has .current. It will return a number (from 0 to 5), that is related to the active tab  */
                        currentId = index;
                    };
                });
                return currentId;
            }

            function navClick(selectedId, direction) {
                if (tabContents[selectedId]) {
                    navCurrentTabContentId = tabContents[selectedId].getAttribute('id');

                    if (navCurrentTabContentId !== $this.tabContent.RESTRICTED) {
                        //remove current class to the tab menu
                        $("." + xgmeMenuItemClass).removeClass("current");
                        $("button[data-body-target='" + navCurrentTabContentId + "']").addClass("current");

                        var nextTabContent = $("#" + navCurrentTabContentId);
                        updateCurrentTabClass(currentTabContent, nextTabContent);

                        currentTabContent = nextTabContent;

                        $this.initTab(navCurrentTabContentId);
                    }
                }
            }

            function updateCurrentTabClass(currentTab, nextTab) {
                currentTab.removeClass("current pt-page-moveFromRightFade pt-page-moveFromLeftFade");
                nextTab.addClass("current");
            }

            return dfd.promise();
        },
        saveGallery: function () {
            return $this.saveGalleryV2();
        },
        isGalleryOrigin: function () {
            return IS_GALLERY_ORIGIN;
        },
        isLicenseOk: function () {
            return IS_LICENSE_OK;
        }
    }


}
