/**
 * Gallery Macro Launcher
 * author: mark dl
 */
AJS.bind("init.rte", function() {
   var macroName = 'xalt-gallery';
   var masonryMacroName = 'advanced-image-gallery-masonry';
   var currentMacroName = 'xalt-gallery';
   var isTemplateContent = AJS.params.contentType === 'template';

   var advancedImageGalleryMacroOverride = {
       opener: function(macro) {

           var xaltGalleryUtils = xaltGalleryMacroUtils(AJS.$, macro);

           var macroParamGalleryName = "";
           var isCreateNew = true;
           var macroParamGalleryType = '';

           if (macro.name === masonryMacroName) {
               macroParamGalleryType = 'masonry';
               currentMacroName = masonryMacroName;
           } else { // to switch back the gallery name if it was converted to masonry when having more than one gallery in one page
               macroParamGalleryType = 'default';
               currentMacroName = macroName;
           }
           if (macro.params != undefined && !isTemplateContent) {
               macroParamGalleryName = macro.params.galleryName;
               if (macroParamGalleryName) {
                   isCreateNew = false;
               }

               if (macro.params.galleryType) {
                   macroParamGalleryType = macro.params.galleryType;
               }
           }

           if (isTemplateContent) { // revert initial request to current version.
               macroParamGalleryName = '';
               macroParamGalleryType = 'default';
           }

           //Pass galleryName parameter for this endpoint request
           $.ajax({
               url: xaltGalleryUtils.getContextPath() + '/rest/xalt-gallery/1.0/xalt-gallery-macro/getmacro?spaceKey='+
                 xaltGalleryUtils.getSpaceKey()+'&pageId='+xaltGalleryUtils.getPageId()+'&galleryName='+
                 encodeURIComponent(macroParamGalleryName) + '&galleryType=' + macroParamGalleryType,
               type: 'GET',
               success: function(result) {
                   Dropzone.autoDiscover = false;

                   AJS.$("#xalt-gallery-macro-dialog").remove();
                   var soyParams = {
                       panelContent: result
                   }

                   var dialog2 = AJS.dialog2(XALT.AdvancedGallery.AdvancedGallerySoy.advancedImageGallerySettings(soyParams)).show();
                   var xaltGalleryEditor = xaltGalleryMacroEditor(AJS.$, xaltGalleryUtils);

                   //call here script for xalt-gallery-macro page.
                   xaltGalleryEditor.initEditor(isCreateNew, macroParamGalleryName).then(function() {
                       if (xaltGalleryEditor.isLicenseOk() && xaltGalleryEditor.isGalleryOrigin()) {

                           AJS.$('#adva-edit-cancel').click(function (e) {
                               e.preventDefault();
                               dialog2.hide();
                           });

                           AJS.$('#adva-edit-save').click(function (e) {
                               e.preventDefault();

                               xaltGalleryEditor.saveGallery().then(
                                 function(gallery) {
                                     var macro = {
                                         name: currentMacroName,
                                         params: {
                                             galleryName: gallery.name,
                                             galleryWidth: gallery.galleryWidth,
                                             galleryHeight: gallery.galleryHeight,
                                             gallerySize: gallery.gallerySize
                                         }

                                     }
                                     tinymce.confluence.macrobrowser.macroBrowserComplete(macro);
                                     dialog2.hide();
                                 });
                           });
                       } else {
                           AJS.$('#adva-edit-cancel').click(function (e) {
                               e.preventDefault();
                               dialog2.hide();
                           });

                           AJS.$('#adva-edit-save').hide();
                       }

                       dialog2.show();
                   });
               }
           });
       }
   };

   AJS.MacroBrowser.setMacroJsOverride(macroName, advancedImageGalleryMacroOverride);
   AJS.MacroBrowser.setMacroJsOverride(masonryMacroName, advancedImageGalleryMacroOverride);
});










