(function (AJS, $) {
  XALT.AdvancedGallery.Admin.ProgressRunner = (function () {
    var URL = '/rest/api/longtask/';
    var QUICK_PROGRESS_POLL_INTERVAL = 100;
    var REGULAR_PROGRESS_POLL_INTERVAL = 1000;
    var PROGRESS_INDICATOR_SELECTOR = '#progress-indicator';
    var $CONTAINER;
    var onStatusFn;

    var $this = {
      run: function (taskID, $container, onStatus) {
        $CONTAINER = $container;
        onStatusFn = onStatus;

        var timeout;
        var timesPolled = 0;
        var progressBar = $(PROGRESS_INDICATOR_SELECTOR);
        progressBar.attr('value', 0);

        var process = function () {
          $.ajax({
            url: AJS.Meta.get('context-path') + URL + taskID
          })
            .done(function (res) {
              $this.updateDisplayStatus(res);

              if (!res.successful) {
                clearTimeout(timeout);
                return $this.errorResult();
              }

              progressBar.attr('value', res.percentageComplete / 100);

              if (+res.percentageComplete >= 100) {
                clearTimeout(timeout);
                if (res.successful) {
                  $this.successResult();
                }
                return null;
              }

              updateStatusPoller();
              return null;
            })
            .fail(function () {
              clearTimeout(timeout);
            });
        };
        var updateStatusPoller = function () {
          timeout = setTimeout(process, timesPolled++ < 10 ? QUICK_PROGRESS_POLL_INTERVAL : REGULAR_PROGRESS_POLL_INTERVAL);
        };

        process();
      },
      updateDisplayStatus: function (status) {
        var $status = $CONTAINER.find('#status');
        $status.html(onStatusFn(status));
      },
      successResult: function () {
        $('#advanced-gallery-re-scale-btn').enable();
        AJS.flag({type: 'success', body: AJS.I18n.getText('xalt-advanced-gallery-configuration.re-scale.task.success.msg'),
          close: 'auto'});
      },
      errorResult: function () {
        $(PROGRESS_INDICATOR_SELECTOR).attr('indeterminate', '');
        AJS.flag({type: 'error', body: AJS.I18n.getText('xalt-advanced-gallery-configuration.re-scale.task.error.msg'),
          close: 'auto'});
      }
    };

    return {
      init: function (taskID, $container, onStatus) {
        $this.run(taskID, $container, onStatus);
      }
    };
  })();
})(AJS, AJS.$);
