/*
 * Decompiled with CFR 0.152.
 */
package de.xalt.confluence.plugins.util;

public enum XaltGalleryImageSize {
    FULL(0, "full-size", 1200, 900, "1200x900"),
    FULL_2X(0, "full-2x-size", 2400, 1800, "2400x1800"),
    HALF(0, "half-size", 900, 600, "900x600"),
    HALF_2X(0, "half-2x-size", 1800, 1200, "1800x1200"),
    QUARTER(0, "quarter-size", 600, 300, "600x300"),
    QUARTER_2X(0, "quarter-2x-size", 1200, 600, "1200x600"),
    FULL_PORTRAIT(0, "full-portrait-size", 900, 1200, "900x1200"),
    FULL_PORTRAIT_2X(0, "full-2x-portrait-size", 1800, 2400, "1800x2400"),
    HALF_PORTRAIT(0, "half-portrait-size", 600, 900, "600x900"),
    HALF_PORTRAIT_2X(0, "half-2x-portrait-size", 1200, 1800, "1200x1800"),
    QUARTER_PORTRAIT(0, "quarter-portrait-size", 300, 600, "300x600"),
    QUARTER_PORTRAIT_2X(0, "quarter-2x-portrait-size", 600, 1200, "600x1200"),
    THUMBNAIL(0, "thumbnail", 320, 240, "320x240"),
    THUMBNAIL_PORTRAIT(0, "thumbnail-portrait", 240, 320, "240x320");

    private final int size;
    private final int width;
    private final int height;
    private final String name;
    private final String scaleName;

    private XaltGalleryImageSize(int size, String name, int width, int height, String scaleName) {
        this.width = width;
        this.height = height;
        this.size = size;
        this.name = name;
        this.scaleName = scaleName;
    }

    XaltGalleryImageSize get2X() {
        int newWidth = this.width * 2;
        int newHeight = this.height * 2;
        if (XaltGalleryImageSize.HALF_2X.scaleName.equals(newWidth + "x" + newHeight)) {
            return HALF_2X;
        }
        if (XaltGalleryImageSize.FULL_2X.scaleName.equals(newWidth + "x" + newHeight)) {
            return FULL_2X;
        }
        if (XaltGalleryImageSize.QUARTER_PORTRAIT_2X.scaleName.equals(newWidth + "x" + newHeight)) {
            return QUARTER_PORTRAIT_2X;
        }
        if (XaltGalleryImageSize.HALF_PORTRAIT_2X.scaleName.equals(newWidth + "x" + newHeight)) {
            return HALF_PORTRAIT_2X;
        }
        if (XaltGalleryImageSize.FULL_PORTRAIT_2X.scaleName.equals(newWidth + "x" + newHeight)) {
            return FULL_PORTRAIT_2X;
        }
        return QUARTER_2X;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getSize() {
        return this.size;
    }

    public String getName() {
        return this.name;
    }

    public String getScaleName() {
        return this.scaleName;
    }
}

