/*
 * Decompiled with CFR 0.152.
 */
package de.xalt.confluence.plugins.util;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThumbnailResizer {
    private static final Logger log = LoggerFactory.getLogger(ThumbnailResizer.class);

    public static void resize(String inputImagePath, int scaledWidth, int scaledHeight) throws IOException {
        log.info("Resizing image: " + inputImagePath);
        log.info("Scaled Width: " + scaledWidth);
        log.info("Scaled Heigth: " + scaledHeight);
        File inputFile = new File(inputImagePath);
        BufferedImage inputImage = ImageIO.read(inputFile);
        BufferedImage outputImage = new BufferedImage(scaledWidth, scaledHeight, inputImage.getType());
        Graphics2D g2d = outputImage.createGraphics();
        g2d.drawImage(inputImage, 0, 0, scaledWidth, scaledHeight, null);
        g2d.dispose();
        String formatName = inputImagePath.substring(inputImagePath.lastIndexOf(".") + 1);
        ImageIO.write((RenderedImage)outputImage, formatName, new File(inputImagePath));
        log.info("Thumbnail generated: " + outputImage);
    }

    public static void resize(String inputImagePath, String outputImagePath, double percent, String userAgent, String sessionId) {
        log.info("Preparing thumbnail generation for image: " + inputImagePath);
        try {
            URL url = new URL(inputImagePath);
            HttpURLConnection httpcon = (HttpURLConnection)url.openConnection();
            httpcon.addRequestProperty("User-Agent", userAgent);
            httpcon.setRequestProperty("Cookie", "JSESSIONID=" + URLEncoder.encode(sessionId, "UTF-8"));
            InputStream inputStream = httpcon.getInputStream();
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)new File(outputImagePath));
            File inputFile = new File(outputImagePath);
            BufferedImage inputImage = ImageIO.read(inputFile);
            int scaledWidth = (int)((double)inputImage.getWidth() * percent);
            int scaledHeight = (int)((double)inputImage.getHeight() * percent);
            ThumbnailResizer.resize(outputImagePath, scaledWidth, scaledHeight);
        }
        catch (Exception e) {
            log.error("Error generating thumbnail!");
            log.error(e.getMessage());
        }
    }
}

