/*
 * Decompiled with CFR 0.152.
 */
package de.xalt.confluence.plugins.util;

import com.twelvemonkeys.image.ResampleOp;
import de.xalt.confluence.plugins.util.ImageRotator;
import de.xalt.confluence.plugins.util.XaltGalleryImageSize;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class ImageScaler {
    private static final Logger log = LoggerFactory.getLogger(ImageScaler.class);

    /*
     * Unable to fully structure code
     */
    public BufferedImage loadFromStream(InputStream originalImageInputStream, InputStream metaDataInputStream) throws IOException {
        input = ImageIO.createImageInputStream(originalImageInputStream);
        var4_4 = null;
        try {
            readers = ImageIO.getImageReaders(input);
            while (readers != null && readers.hasNext()) {
                reader = readers.next();
                orientation = ImageRotator.getOrientation(metaDataInputStream);
                try {
                    reader.setInput(input);
                    image = reader.read(0);
                    if (orientation > 0) {
                        image = ImageRotator.imageRotateBasedOnOrientation(orientation, image);
                    }
                    var9_12 = image;
                    return var9_12;
                }
                catch (IIOException image) {
                    ** try [egrp 4[TRYBLOCK] [7 : 123->161)] { 
lbl17:
                    // 1 sources

                    continue;
                }
                {
                    catch (Exception e) {
                        throw e;
                    }
                }
                finally {
                    reader.dispose();
                }
            }
            {
                throw new IIOException("Unable to load image");
            }
lbl-1000:
            // 2 sources

            {
                catch (Throwable var5_6) {
                    var4_4 = var5_6;
                    throw var5_6;
                }
            }
        }
        finally {
            if (input != null) {
                if (var4_4 != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable var10_13) {
                        var4_4.addSuppressed(var10_13);
                    }
                } else {
                    input.close();
                }
            }
        }
    }

    public ByteArrayOutputStream scale(BufferedImage originalImage, XaltGalleryImageSize size, String fileExtension) throws IOException {
        if (originalImage == null) {
            log.debug("image not found");
            return null;
        }
        log.debug("size of original image: {}x{}", (Object)originalImage.getWidth(), (Object)originalImage.getHeight());
        if (this.needsNoScaling(size.getHeight(), size.getWidth(), originalImage)) {
            log.debug("image dimensions don't exceed {} pixels, no resize needed.", (Object)size.getHeight(), (Object)size.getWidth());
            return null;
        }
        return this.process(originalImage, size, fileExtension);
    }

    private ByteArrayOutputStream process(BufferedImage originalImage, XaltGalleryImageSize size, String fileExtension) throws IOException {
        long start = System.currentTimeMillis();
        double srcWidth = originalImage.getWidth();
        double srcHeight = originalImage.getHeight();
        double srcAspectRatio = srcWidth / srcHeight;
        int targetWidth = (int)((double)size.getHeight() * srcAspectRatio);
        int resampleFilter = 13;
        if (fileExtension.equals("png")) {
            resampleFilter = 3;
        }
        ResampleOp resampler = new ResampleOp(targetWidth, size.getHeight(), resampleFilter);
        BufferedImage output = resampler.filter(originalImage, null);
        log.debug("scaled image to size {}x{}", (Object)output.getWidth(), (Object)output.getHeight());
        ByteArrayOutputStream scaledImageOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)output, fileExtension, scaledImageOutputStream);
        log.debug("stream size: {} bytes, scaling took {}ms", (Object)scaledImageOutputStream.size(), (Object)(System.currentTimeMillis() - start));
        return scaledImageOutputStream;
    }

    private boolean needsNoScaling(int heightThreshold, int widthThreshold, BufferedImage image) {
        return image.getWidth() <= widthThreshold && image.getHeight() <= heightThreshold;
    }
}

