/*
 * Decompiled with CFR 0.152.
 */
package de.xalt.confluence.plugins.transaction;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.core.util.ProgressMeter;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.xalt.confluence.plugins.model.Gallery;
import de.xalt.confluence.plugins.model.GalleryScale;
import de.xalt.confluence.plugins.model.ImageResponse;
import de.xalt.confluence.plugins.model.Picture;
import de.xalt.confluence.plugins.model.ReScaleProgress;
import de.xalt.confluence.plugins.service.GalleryService;
import de.xalt.confluence.plugins.util.ImageScalerHelper;
import de.xalt.confluence.plugins.util.ReScaleTaskStatus;
import de.xalt.confluence.plugins.util.XaltGalleryImageSize;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

@Named
public class ScaleImageTransaction {
    private static final Logger log = LoggerFactory.getLogger(ScaleImageTransaction.class);
    private final ImageScalerHelper imageScalerHelper;
    private final GalleryService galleryService;
    private static final String DISPLAY_TYPE_MASONRY = "masonry";
    private final ContentEntityManager contentEntityManager;

    @Inject
    public ScaleImageTransaction(ImageScalerHelper imageScalerHelper, GalleryService galleryService, @ComponentImport @Qualifier(value="contentEntityManager") ContentEntityManager contentEntityManager) {
        this.imageScalerHelper = imageScalerHelper;
        this.galleryService = galleryService;
        this.contentEntityManager = contentEntityManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long scaleImageTransaction(Gallery gallery, List<Picture> pictureList, Picture picture, Attachment image) {
        GalleryScale currentScale = this.createGalleryScaleByGallery(gallery);
        XaltGalleryImageSize targetSize = this.imageScalerHelper.getTargetScaleSize(currentScale.getWidth(), currentScale.getHeight());
        ContentEntityObject ceo = this.contentEntityManager.getById(Long.valueOf(gallery.getPageId()).longValue());
        ImageResponse imageResponse = this.imageScalerHelper.scaleImage(image, ceo, targetSize);
        String scaledImageURL = null;
        String scaledd2xImageURL = null;
        Integer width = null;
        Integer height = null;
        if (imageResponse != null) {
            scaledImageURL = imageResponse.getScaledImageURL();
            scaledd2xImageURL = imageResponse.getScaled2xImageURL();
            width = imageResponse.getWidth();
            height = imageResponse.getHeight();
        }
        picture.setScaledImageURL(scaledImageURL);
        picture.setScaled2xImageURL(scaledd2xImageURL);
        picture.setOriginalWidth(width);
        picture.setOriginalHeight(height);
        gallery.setPictures(pictureList);
        try {
            this.galleryService.updateGallery(gallery, "de.xalt.confluence.plugins.advanced-gallery-macro.xalt-gallery", gallery.getName());
        }
        catch (Exception e) {
            log.error("Error updating Gallery on Page ID - " + gallery.getPageId());
            log.error(e.getMessage());
        }
        finally {
            return Long.valueOf(gallery.getPageId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long scaleGalleryTransaction(Picture picture, Gallery gallery, List<Picture> pictureList, ReScaleProgress reScaleProgress) {
        GalleryScale currentScale = this.createGalleryScaleByGallery(gallery);
        ImageResponse scaledImage = this.imageScalerHelper.prepScaleImage(Long.valueOf(gallery.getPageId()), picture.getFileName(), (int)currentScale.getWidth(), (int)currentScale.getHeight());
        String scaledImageURL = null;
        String scaledd2xImageURL = null;
        Integer width = null;
        Integer height = null;
        if (scaledImage != null) {
            scaledImageURL = scaledImage.getScaledImageURL();
            scaledd2xImageURL = scaledImage.getScaled2xImageURL();
            width = scaledImage.getWidth();
            height = scaledImage.getHeight();
        }
        picture.setScaledImageURL(scaledImageURL);
        picture.setScaled2xImageURL(scaledd2xImageURL);
        picture.setOriginalWidth(width);
        picture.setOriginalHeight(height);
        gallery.setPictures(pictureList);
        try {
            this.galleryService.updateGallery(gallery, "de.xalt.confluence.plugins.advanced-gallery-macro.xalt-gallery", gallery.getName());
            if (reScaleProgress != null) {
                ProgressMeter rescaleProgressMeter = reScaleProgress.getProgressMeter();
                int currentCount = rescaleProgressMeter.getCurrentCount();
                rescaleProgressMeter.setCurrentCount(++currentCount);
                rescaleProgressMeter.setPercentage(currentCount, reScaleProgress.getTotalImages());
            }
        }
        catch (Exception e) {
            log.error("Error updating Gallery on Page ID - " + gallery.getPageId());
            log.error(e.getMessage());
            if (reScaleProgress != null) {
                ProgressMeter rescaleProgressMeter = reScaleProgress.getProgressMeter();
                rescaleProgressMeter.setStatus(ReScaleTaskStatus.FAILED.getI18n());
                rescaleProgressMeter.setCompletedSuccessfully(false);
            }
        }
        finally {
            return Long.valueOf(gallery.getPageId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long scaleGalleryTransaction(Picture picture, Gallery gallery, List<Picture> pictureList, ReScaleProgress reScaleProgress, ContentEntityObject ceo) {
        GalleryScale currentScale = this.createGalleryScaleByGallery(gallery);
        ImageResponse scaledImage = this.imageScalerHelper.prepScaleImage(ceo, picture.getFileName(), (int)currentScale.getWidth(), (int)currentScale.getHeight());
        String scaledImageURL = null;
        String scaledd2xImageURL = null;
        Integer width = null;
        Integer height = null;
        if (scaledImage != null) {
            scaledImageURL = scaledImage.getScaledImageURL();
            scaledd2xImageURL = scaledImage.getScaled2xImageURL();
            width = scaledImage.getWidth();
            height = scaledImage.getHeight();
        }
        picture.setScaledImageURL(scaledImageURL);
        picture.setScaled2xImageURL(scaledd2xImageURL);
        picture.setOriginalWidth(width);
        picture.setOriginalHeight(height);
        gallery.setPictures(pictureList);
        try {
            this.galleryService.updateGallery(gallery, "de.xalt.confluence.plugins.advanced-gallery-macro.xalt-gallery", gallery.getName());
            if (reScaleProgress != null) {
                ProgressMeter rescaleProgressMeter = reScaleProgress.getProgressMeter();
                int currentCount = rescaleProgressMeter.getCurrentCount();
                rescaleProgressMeter.setCurrentCount(++currentCount);
                rescaleProgressMeter.setPercentage(currentCount, reScaleProgress.getTotalImages());
            }
        }
        catch (Exception e) {
            log.error("Error updating Gallery on Page ID - " + gallery.getPageId());
            log.error(e.getMessage());
            if (reScaleProgress != null) {
                ProgressMeter rescaleProgressMeter = reScaleProgress.getProgressMeter();
                rescaleProgressMeter.setStatus(ReScaleTaskStatus.FAILED.getI18n());
                rescaleProgressMeter.setCompletedSuccessfully(false);
            }
        }
        finally {
            return Long.valueOf(gallery.getPageId());
        }
    }

    private GalleryScale createGalleryScaleByGallery(Gallery gallery) {
        if (DISPLAY_TYPE_MASONRY.equals(gallery.getDisplayType())) {
            log.debug("Changing gallery values to half size for masonry");
            return new GalleryScale(XaltGalleryImageSize.HALF.getWidth(), XaltGalleryImageSize.HALF.getHeight());
        }
        return new GalleryScale(Integer.valueOf(gallery.getGalleryWidth()), Integer.valueOf(gallery.getGalleryHeight()));
    }
}

