/*
 * Decompiled with CFR 0.152.
 */
package de.xalt.confluence.plugins.service.impl;

import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.xalt.confluence.plugins.model.Gallery;
import de.xalt.confluence.plugins.model.Picture;
import de.xalt.confluence.plugins.service.MobileService;
import java.net.URI;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="mobileService")
public class MobileServiceImpl
implements MobileService {
    private static final Logger log = LoggerFactory.getLogger(MobileServiceImpl.class);
    @ComponentImport
    private final SettingsManager settingsManager;

    @Inject
    public MobileServiceImpl(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    @Override
    public String convertGalleryToPlainHtml(Gallery gallery) {
        Element galleryContainer = new Element(Tag.valueOf("div"), "");
        galleryContainer.attr("class", "adva-plain-container");
        String htmlValue = "";
        try {
            String baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
            URI uri = new URI(baseUrl);
            String contextPath = uri.getPath();
            AtomicInteger counter = new AtomicInteger();
            gallery.getPictures().forEach(picture -> {
                Element pictureContainer = new Element(Tag.valueOf("div"), "");
                pictureContainer.attr("class", "adva-picture-" + counter.getAndIncrement());
                Element imageElement = new Element(Tag.valueOf("img"), "");
                String imageLink = picture.getLinkDownload();
                if (!StringUtils.isEmpty((CharSequence)picture.getScaledImageURL())) {
                    imageLink = picture.getScaledImageURL();
                }
                if (imageLink.startsWith(contextPath) || imageLink.startsWith(contextPath.substring(1))) {
                    imageElement.attr("src", imageLink);
                } else {
                    imageElement.attr("src", uri.getPath() + "/" + imageLink);
                }
                imageElement.attr("style", "width:100%");
                Element footerContainer = MobileServiceImpl.prepareFooterElement(picture);
                pictureContainer.appendChild(imageElement);
                if (!picture.getCaptions().isEmpty()) {
                    pictureContainer.appendChild(footerContainer);
                }
                galleryContainer.appendChild(pictureContainer);
            });
            htmlValue = galleryContainer.toString();
        }
        catch (Exception e) {
            log.debug("Unable to convert base URL to URI. Returning blank string.", (Throwable)e);
        }
        return htmlValue;
    }

    private static Element prepareFooterElement(Picture picture) {
        Element footerContainer = new Element(Tag.valueOf("div"), null);
        footerContainer.addClass("plain-view-footer-container");
        picture.getCaptions().entrySet().forEach(currentCaption -> {
            if (StringUtils.isNotEmpty((CharSequence)((CharSequence)currentCaption.getValue()))) {
                Element footerCaption = new Element(Tag.valueOf("div"), null);
                footerCaption.addClass("plain-view-footer-caption");
                StringBuilder cssString = new StringBuilder().append("font-style: italic;").append("font-size: 4vw;").append("text-align: center;").append("padding-bottom: 1em;").append("line-height: normal;");
                footerCaption.attr("style", cssString.toString());
                footerCaption.append((String)currentCaption.getValue());
                footerContainer.appendChild(footerCaption);
            }
        });
        return footerContainer;
    }
}

