/*
 * Decompiled with CFR 0.152.
 */
package de.xalt.confluence.plugins.service.impl;

import com.google.gson.Gson;
import de.xalt.confluence.plugins.exception.DuplicateGalleryNameException;
import de.xalt.confluence.plugins.model.Gallery;
import de.xalt.confluence.plugins.model.GallerySettings;
import de.xalt.confluence.plugins.repository.GalleryRepository;
import de.xalt.confluence.plugins.service.GalleryService;
import de.xalt.confluence.plugins.util.XaltGalleryUtil;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class GalleryServiceImpl
implements GalleryService {
    @Autowired
    private GalleryRepository galleryRepository;

    @Override
    public void saveGallery(Gallery gallery, String context, String id) throws DuplicateGalleryNameException, Exception {
        Gallery existingGallery = null;
        existingGallery = this.galleryRepository.get(context, id);
        if (existingGallery != null) {
            throw new DuplicateGalleryNameException("Gallery: " + gallery + " already exists");
        }
        this.galleryRepository.save(gallery, context, id);
    }

    @Override
    public void saveGalleryWithSettings(Gallery gallery, GallerySettings setting, String context, String id) throws DuplicateGalleryNameException, Exception {
        this.saveGallery(gallery, context, id);
        Gson gson = new Gson();
        String settingJson = gson.toJson(setting);
        this.galleryRepository.saveSettings(settingJson, "de.xalt.confluence.plugins.advanced-gallery-macro.xalt-gallery-setting", id);
    }

    @Override
    public void removeGallery(String context, String id) {
        this.galleryRepository.remove(context, id);
    }

    @Override
    public void removeGalleryWithSetting(String context, String id) {
        this.removeGallery(context, id);
        this.galleryRepository.remove("de.xalt.confluence.plugins.advanced-gallery-macro.xalt-gallery-setting", id);
    }

    @Override
    public void updateGallery(Gallery gallery, String context, String id) throws Exception {
        this.galleryRepository.save(gallery, context, id);
    }

    @Override
    public void updateGalleryWithSetting(Gallery gallery, GallerySettings setting, String context, String id) throws Exception {
        this.updateGallery(gallery, context, id);
        Gson gson = new Gson();
        String settingJson = gson.toJson(setting);
        this.galleryRepository.saveSettings(settingJson, "de.xalt.confluence.plugins.advanced-gallery-macro.xalt-gallery-setting", id);
    }

    @Override
    public GallerySettings getGallerySettings(String id) {
        return this.galleryRepository.getSettings("de.xalt.confluence.plugins.advanced-gallery-macro.xalt-gallery-setting", id);
    }

    @Override
    public List<Gallery> getAllGalleries(String context) {
        return this.galleryRepository.getAllGalleries(context);
    }

    @Override
    public Gallery getGallery(String context, String id) {
        Gallery gallery = this.galleryRepository.get(context, id);
        if (gallery != null) {
            XaltGalleryUtil.checkAndSetGallerySize(gallery);
        }
        return gallery;
    }

    @Override
    public int getTotalImages(String context) {
        return this.galleryRepository.getTotalImages(context);
    }

    public void setGalleryRepository(GalleryRepository galleryRepository) {
        this.galleryRepository = galleryRepository;
    }

    public GalleryRepository getGalleryRepository() {
        return this.galleryRepository;
    }
}

