/*
 * Decompiled with CFR 0.152.
 */
package de.xalt.confluence.plugins.resources;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.multipart.FilePart;
import com.atlassian.plugins.rest.common.multipart.MultipartFormParam;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.gson.Gson;
import de.xalt.confluence.plugins.api.GalleryImageScaleLongRunningTask;
import de.xalt.confluence.plugins.api.GalleryScaleLongRunningTask;
import de.xalt.confluence.plugins.model.CroppedImage;
import de.xalt.confluence.plugins.model.ImageResponse;
import de.xalt.confluence.plugins.service.EditImageService;
import de.xalt.confluence.plugins.service.GalleryService;
import de.xalt.confluence.plugins.transaction.ScaleImageTransaction;
import de.xalt.confluence.plugins.util.ImageScalerHelper;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/scale-image")
@Scanned
public class XaltGalleryScaleImage {
    private static final Logger log = LoggerFactory.getLogger(XaltGalleryScaleImage.class);
    @ComponentImport
    private final PageManager pageManager;
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    @ComponentImport
    private final LongRunningTaskManager longRunningTaskManager;
    private final ImageScalerHelper imageScalerHelper;
    private final GalleryService galleryService;
    private final ScaleImageTransaction scaleImageTransaction;
    private final EditImageService editImageService;

    @Inject
    public XaltGalleryScaleImage(PageManager pageManager, ImageScalerHelper imageScalerHelper, GalleryService galleryService, TransactionTemplate transactionTemplate, ScaleImageTransaction scaleImageTransaction, LongRunningTaskManager longRunningTaskManager, EditImageService editImageService) {
        this.pageManager = pageManager;
        this.imageScalerHelper = imageScalerHelper;
        this.galleryService = galleryService;
        this.transactionTemplate = transactionTemplate;
        this.scaleImageTransaction = scaleImageTransaction;
        this.longRunningTaskManager = longRunningTaskManager;
        this.editImageService = editImageService;
    }

    @POST
    @Path(value="/crop")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response cropImage(CroppedImage croppedImage, @QueryParam(value="attachmentName") String imageFileName, @QueryParam(value="pageId") Long pageID, @QueryParam(value="galleryName") String galleryName) {
        Attachment croppedImageAttachment;
        Attachment latestAttachment;
        AbstractPage page = this.pageManager.getAbstractPage(pageID.longValue());
        Attachment attachment = this.imageScalerHelper.getImage(imageFileName, (ContentEntityObject)page);
        Attachment attachment2 = latestAttachment = attachment != null ? (Attachment)attachment.getLatestVersion() : null;
        if (latestAttachment != null && !latestAttachment.isDeleted() && (croppedImageAttachment = this.imageScalerHelper.cropImage(croppedImage, latestAttachment, page)) != null) {
            ImageResponse imageResponse = new ImageResponse(croppedImageAttachment, null, null, null, null);
            String strImageResponse = new Gson().toJson(imageResponse);
            if (!StringUtils.isBlank((String)galleryName)) {
                GalleryImageScaleLongRunningTask imageScaleTask = new GalleryImageScaleLongRunningTask(this.pageManager, this.transactionTemplate, this.imageScalerHelper, this.galleryService, this.scaleImageTransaction, pageID, galleryName, imageFileName);
                this.longRunningTaskManager.startLongRunningTask(null, (LongRunningTask)imageScaleTask);
            }
            return Response.ok((Object)strImageResponse).build();
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="/gallery")
    public Response scaleGalleryImages(@QueryParam(value="galleryName") String galleryName, @QueryParam(value="pageId") Long pageID) {
        if (StringUtils.isBlank((String)galleryName)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        GalleryScaleLongRunningTask galleryScaleTask = new GalleryScaleLongRunningTask(this.transactionTemplate, this.galleryService, this.scaleImageTransaction, galleryName);
        this.longRunningTaskManager.startLongRunningTask(null, (LongRunningTask)galleryScaleTask);
        return Response.ok().build();
    }

    @POST
    @Path(value="/crop-v2")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public Response cropVersion2(@QueryParam(value="attachmentName") String imageFileName, @QueryParam(value="pageId") Long pageId, @QueryParam(value="galleryName") String galleryName, @MultipartFormParam(value="croppedImage") FilePart croppedImage) {
        Attachment croppedImageAttachment = this.editImageService.cropImage(imageFileName, pageId, croppedImage);
        if (croppedImageAttachment != null) {
            ImageResponse imageResponse = new ImageResponse(croppedImageAttachment, null, null, null, null);
            String strImageResponse = new Gson().toJson(imageResponse);
            if (!StringUtils.isBlank((String)galleryName)) {
                GalleryImageScaleLongRunningTask imageScaleTask = new GalleryImageScaleLongRunningTask(this.pageManager, this.transactionTemplate, this.imageScalerHelper, this.galleryService, this.scaleImageTransaction, pageId, galleryName, imageFileName);
                this.longRunningTaskManager.startLongRunningTask(null, (LongRunningTask)imageScaleTask);
            }
            return Response.ok((Object)strImageResponse).build();
        }
        return Response.ok().build();
    }
}

