/*
 * Decompiled with CFR 0.152.
 */
package de.xalt.confluence.plugins.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.ConfluenceMockServletRequest;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import de.xalt.confluence.plugins.model.Gallery;
import de.xalt.confluence.plugins.service.GalleryService;
import de.xalt.confluence.plugins.service.MobileService;
import de.xalt.confluence.plugins.util.MobileUtils;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
public class XaltGallery
extends BaseMacro
implements Macro {
    private static final Logger log = LoggerFactory.getLogger(XaltGallery.class);
    private final GalleryService galleryService;
    private final MobileService mobileService;

    @Inject
    public XaltGallery(GalleryService galleryService, MobileService mobileService) {
        this.galleryService = galleryService;
        this.mobileService = mobileService;
    }

    public String execute(Map<String, String> params, String body, ConversionContext conversionContext) throws MacroExecutionException {
        Map contextMap = MacroUtils.defaultVelocityContext();
        Object reqObject = contextMap.get("req");
        if (reqObject == null) {
            throw new MacroExecutionException("reqObject is null");
        }
        String agentHeader = null;
        if (reqObject instanceof HttpServletRequest) {
            HttpServletRequest req = (HttpServletRequest)reqObject;
            agentHeader = req.getHeader("user-agent");
        } else if (!(reqObject instanceof ConfluenceMockServletRequest)) {
            throw new MacroExecutionException("Unexpected type of reqObject: " + reqObject.getClass().getName());
        }
        boolean isMobileView = agentHeader != null && MobileUtils.isMobileViewRequest(agentHeader);
        String galleryName = params.get("galleryName");
        if (isMobileView) {
            Gallery gallery = this.galleryService.getGallery("de.xalt.confluence.plugins.advanced-gallery-macro.xalt-gallery", galleryName);
            String galleryHtml = this.mobileService.convertGalleryToPlainHtml(gallery);
            contextMap.put("plainGalleryHtml", galleryHtml);
            return VelocityUtils.getRenderedTemplate((String)"gallery-view-plain.vm", (Map)contextMap);
        }
        String galleryWidth = params.get("galleryWidth");
        String galleryHeight = params.get("galleryHeight");
        contextMap.put("galleryName", galleryName);
        contextMap.put("galleryWidth", galleryWidth);
        contextMap.put("galleryHeight", galleryHeight);
        return VelocityUtils.getRenderedTemplate((String)"xalt-gallery-view.vm", (Map)contextMap);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return null;
    }

    public String execute(Map map, String s, RenderContext renderContext) throws MacroException {
        return null;
    }

    public GalleryService getGalleryService() {
        return this.galleryService;
    }

    public MobileService getMobileService() {
        return this.mobileService;
    }
}

