/*
 * Decompiled with CFR 0.152.
 */
package de.xalt.confluence.plugins.eventlistener;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostCreateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import de.xalt.confluence.plugins.api.GalleryScaleLongRunningTask;
import de.xalt.confluence.plugins.model.Gallery;
import de.xalt.confluence.plugins.model.GallerySettings;
import de.xalt.confluence.plugins.model.Picture;
import de.xalt.confluence.plugins.service.GalleryService;
import de.xalt.confluence.plugins.transaction.ScaleImageTransaction;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Named
public class PageAndBlogPostPublishListener
implements DisposableBean,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(PageAndBlogPostPublishListener.class);
    @ComponentImport
    private final EventPublisher eventPublisher;
    @ComponentImport
    private XhtmlContent xhtmlContent;
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    @ComponentImport
    private final LongRunningTaskManager longRunningTaskManager;
    private final ContentEntityManager contentEntityManager;
    private final ScaleImageTransaction scaleImageTransaction;
    @Autowired
    private GalleryService galleryService;
    private static Pattern attachmentLinkPattern = Pattern.compile("(attachments\\/)([0-9]*)(\\/)");

    @Inject
    public void setXhtmlContent(XhtmlContent xhtmlContent) {
        this.xhtmlContent = xhtmlContent;
    }

    @Inject
    public PageAndBlogPostPublishListener(EventPublisher eventPublisher, TransactionTemplate transactionTemplate, LongRunningTaskManager longRunningTaskManager, ScaleImageTransaction scaleImageTransaction, @ComponentImport @Qualifier(value="contentEntityManager") ContentEntityManager contentEntityManager) {
        this.eventPublisher = eventPublisher;
        this.transactionTemplate = transactionTemplate;
        this.longRunningTaskManager = longRunningTaskManager;
        this.scaleImageTransaction = scaleImageTransaction;
        this.contentEntityManager = contentEntityManager;
    }

    @EventListener
    public void pageUpdateEvent(PageUpdateEvent event) {
        if (event == null || this.xhtmlContent == null) {
            return;
        }
        this.updateGalleryIdFromDraft(event.getContent());
    }

    @EventListener
    public void pageCreateEvent(PageCreateEvent event) {
        if (event == null || this.xhtmlContent == null) {
            return;
        }
        this.updateGalleryIdFromDraft(event.getContent());
    }

    @EventListener
    public void blogPostUpdateEvent(BlogPostUpdateEvent event) {
        if (event == null || this.xhtmlContent == null) {
            return;
        }
        this.updateGalleryIdFromDraft(event.getContent());
    }

    @EventListener
    public void blogPostCreateEvent(BlogPostCreateEvent event) {
        if (event == null || this.xhtmlContent == null) {
            return;
        }
        this.updateGalleryIdFromDraft(event.getContent());
    }

    private void updateGalleryIdFromDraft(ContentEntityObject contentEntityObject) {
        try {
            this.xhtmlContent.handleMacroDefinitions(contentEntityObject.getBodyAsString(), (ConversionContext)new DefaultConversionContext(new RenderContext()), macroDefinition -> {
                if ("xalt-gallery".equals(macroDefinition.getName())) {
                    Map params = macroDefinition.getParameters();
                    String galleryId = (String)params.get("galleryName");
                    String pageId = contentEntityObject.getIdAsString();
                    Gallery gallery = this.galleryService.getGallery("de.xalt.confluence.plugins.advanced-gallery-macro.xalt-gallery", galleryId);
                    if (gallery == null) {
                        log.error(String.format("no gallery was found with galleryId (%s) from pageId (%s)", galleryId, pageId));
                        return;
                    }
                    String currentGalleryPageId = gallery.getPageId();
                    ContentEntityObject currentGalleryPageIdCeo = this.contentEntityManager.getById(Long.valueOf(currentGalleryPageId).longValue());
                    if (!(currentGalleryPageIdCeo == null || currentGalleryPageIdCeo.isDeleted() || currentGalleryPageIdCeo.isDraft() || currentGalleryPageIdCeo.getIdAsString().equals(pageId))) {
                        log.debug("Gallery is still referenced to an existing page. Will not update gallery content Ids");
                        return;
                    }
                    GallerySettings settings = this.galleryService.getGallerySettings(galleryId);
                    gallery.setPageId(pageId);
                    gallery.setSavedFromDraft(false);
                    List<Picture> pictures = gallery.getPictures().stream().map(picture -> {
                        String newLink = this.updateImageLinkUrl(picture.getLinkDownload(), pageId);
                        String newScaledImageUrl = this.updateImageLinkUrl(picture.getScaledImageURL(), pageId);
                        String newScaled2xImageUrl = this.updateImageLinkUrl(picture.getScaled2xImageURL(), pageId);
                        picture.setLinkDownload(newLink);
                        picture.setScaledImageURL(newScaledImageUrl);
                        picture.setScaled2xImageURL(newScaled2xImageUrl);
                        picture.setContentId(pageId);
                        return picture;
                    }).collect(Collectors.toList());
                    gallery.setPictures(pictures);
                    try {
                        this.galleryService.updateGallery(gallery, "de.xalt.confluence.plugins.advanced-gallery-macro.xalt-gallery", galleryId);
                    }
                    catch (Exception e) {
                        log.error("Error saving Gallery");
                        log.error(e.getMessage());
                    }
                    this.checkAndScaleImages(contentEntityObject, galleryId, gallery, settings);
                }
            });
        }
        catch (XhtmlException ex) {
            log.error("Error while indexing instances of your-macro on page/blogpost " + contentEntityObject.getIdAsString(), (Throwable)ex);
        }
    }

    private void checkAndScaleImages(ContentEntityObject contentEntityObject, String galleryId, Gallery gallery, GallerySettings settings) {
        if (!settings.isImagesScaled() && !settings.isScalingImages()) {
            log.debug("Gallery is not yet scaled. Attempting to re-scale gallery images.");
            GalleryScaleLongRunningTask galleryScaleTask = new GalleryScaleLongRunningTask(this.transactionTemplate, this.galleryService, this.scaleImageTransaction, galleryId, contentEntityObject, gallery, settings);
            this.longRunningTaskManager.startLongRunningTask(null, (LongRunningTask)galleryScaleTask);
        }
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    private String updateImageLinkUrl(String oldValue, String newValue) {
        if (!StringUtils.isEmpty((String)oldValue)) {
            log.debug("update content id of link {} with {}", (Object)oldValue, (Object)newValue);
            return attachmentLinkPattern.matcher(oldValue).replaceFirst("$1" + newValue + "$3");
        }
        return "";
    }
}

