/*
 * Decompiled with CFR 0.152.
 */
package de.xalt.confluence.plugins.api;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisplayThumbnailAction
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(DisplayThumbnailAction.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String thumbnailPath = request.getParameter("thumbnailPath");
        if (StringUtils.isEmpty((CharSequence)thumbnailPath)) {
            log.error("Missing parameter: thumbnailPath");
            throw new IllegalArgumentException("ERROR: Missing parameter: 'thumbnailPath'");
        }
        response.setContentType("image/jpeg");
        ServletOutputStream out = response.getOutputStream();
        FileInputStream fin = new FileInputStream(thumbnailPath);
        BufferedInputStream bin = new BufferedInputStream(fin);
        BufferedOutputStream bout = new BufferedOutputStream((OutputStream)out);
        int ch = 0;
        while ((ch = bin.read()) != -1) {
            bout.write(ch);
        }
        bin.close();
        fin.close();
        bout.close();
        out.close();
        response.getWriter().append("Success");
    }
}

