/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.jpeg;

import com.twelvemonkeys.imageio.plugins.jpeg.JPEGImageReader;
import com.twelvemonkeys.imageio.plugins.jpeg.JPEGProviderInfo;
import com.twelvemonkeys.imageio.spi.ImageReaderSpiBase;
import com.twelvemonkeys.imageio.spi.ReaderWriterProviderInfo;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.lang.Validate;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadataFormat;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;

public final class JPEGImageReaderSpi
extends ImageReaderSpiBase {
    protected ImageReaderSpi delegateProvider;

    public JPEGImageReaderSpi() {
        this(new JPEGProviderInfo());
    }

    JPEGImageReaderSpi(ImageReaderSpi imageReaderSpi) {
        this();
        this.delegateProvider = Validate.notNull(imageReaderSpi);
    }

    private JPEGImageReaderSpi(ReaderWriterProviderInfo readerWriterProviderInfo) {
        super(readerWriterProviderInfo);
    }

    @Override
    public void onRegistration(ServiceRegistry serviceRegistry, Class<?> clazz) {
        if (this.delegateProvider == null) {
            this.delegateProvider = IIOUtil.lookupProviderByName(serviceRegistry, "com.sun.imageio.plugins.jpeg.JPEGImageReaderSpi", ImageReaderSpi.class);
        }
        if (this.delegateProvider != null) {
            serviceRegistry.setOrdering(clazz, this, this.delegateProvider);
        } else {
            IIOUtil.deregisterProvider(serviceRegistry, this, clazz);
        }
    }

    @Override
    public String getVendorName() {
        return String.format("%s/%s", super.getVendorName(), this.delegateProvider.getVendorName());
    }

    @Override
    public String getVersion() {
        return String.format("%s/%s", super.getVersion(), this.delegateProvider.getVersion());
    }

    @Override
    public ImageReader createReaderInstance(Object object) throws IOException {
        return new JPEGImageReader(this, this.delegateProvider.createReaderInstance(object));
    }

    @Override
    public boolean canDecodeInput(Object object) throws IOException {
        return this.delegateProvider.canDecodeInput(object);
    }

    @Override
    public boolean isStandardStreamMetadataFormatSupported() {
        return this.delegateProvider.isStandardStreamMetadataFormatSupported();
    }

    @Override
    public String getNativeStreamMetadataFormatName() {
        return this.delegateProvider.getNativeStreamMetadataFormatName();
    }

    @Override
    public String[] getExtraStreamMetadataFormatNames() {
        return this.delegateProvider.getExtraStreamMetadataFormatNames();
    }

    @Override
    public boolean isStandardImageMetadataFormatSupported() {
        return this.delegateProvider.isStandardImageMetadataFormatSupported();
    }

    @Override
    public String getNativeImageMetadataFormatName() {
        return this.delegateProvider.getNativeImageMetadataFormatName();
    }

    @Override
    public String[] getExtraImageMetadataFormatNames() {
        return this.delegateProvider.getExtraImageMetadataFormatNames();
    }

    @Override
    public IIOMetadataFormat getStreamMetadataFormat(String string) {
        return this.delegateProvider.getStreamMetadataFormat(string);
    }

    @Override
    public IIOMetadataFormat getImageMetadataFormat(String string) {
        return this.delegateProvider.getImageMetadataFormat(string);
    }

    @Override
    public String getDescription(Locale locale) {
        return this.delegateProvider.getDescription(locale);
    }

    public Class[] getInputTypes() {
        return this.delegateProvider.getInputTypes();
    }
}

