(function (AJS, $, progressRunner) {
  XALT.AdvancedGallery.Admin.ProgressContainer = (function () {
    var $this = {
      run: function (taskID, $progressContainer) {
        progressRunner.init(taskID, $progressContainer, $this.updateStatus);
      },
      updateStatus: function (res) {
        var status = '';
        if (res.messages.length > 0) {
          status = res.messages[0].translation;
        }
        var completed = res.percentageComplete || '0';
        return AJS.format('{0} {1}%', AJS.I18n.getText(status), completed);
      }
    };

    return {
      init: function (taskID) {
        var $progressContainer = $('#advanced-gallery-rescale-progress-container');
        $progressContainer.show();
        $this.run(taskID, $progressContainer);
      }
    };
  })();
})(AJS, AJS.$, XALT.AdvancedGallery.Admin.ProgressRunner);
