(function (AJS, $) {
  function httpRequest(type, url, params, headers = null) {
    let result;
    try {
      result = $.ajax({
        url,
        data: params,
        type,
        contentType: 'application/json',
        dataType: 'json',
        headers
      });
    } catch (error) {
      throw JSON.parse(error.responseText);
    }
    return result;
  }

  function updateReference(data) {
    const url = `${AJS.contextPath()}/rest/xalt-gallery/1.0/admin-config/update-reference-config`;
    const paramData = JSON.stringify(data);
    return httpRequest('POST', url, paramData);
  }

  function getReference() {
    const url = `${AJS.contextPath()}/rest/xalt-gallery/1.0/admin-config/get-reference-config`;
    return httpRequest('GET', url, {});
  }

  function initReferenceConfig() {
    // Assign reference value to field.
    getReference().then((response) => {
      if (response && response.referenceMessage) {
        $('#aig-reference-message').val(response.referenceMessage);
      }
    });

    // Assign submit button
    $('#aig-reference-config-form').on('submit', (e) => {
      e.preventDefault(); // to prevent from refreshing page upon submit
      const referenceMessage = DOMPurify.sanitize($('#aig-reference-message').val());
      const data = {
        referenceMessage: referenceMessage
      };
      updateReference(data).then(() => {
        $('#aig-reference-message').val(data.referenceMessage);
        AJS.flag({
          type: 'success',
          body: 'Reference message update success.',
          close: 'auto'
        });
      });
    });
  }
  AJS.toInit(initReferenceConfig);
})(AJS, AJS.$);
