/*
 * Decompiled with CFR 0.152.
 */
package de.xalt.confluence.plugins.util;

import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class MobileUtils {
    public static final String DESKTOP_URL_PARAMETER = "desktop";
    private static final Pattern MOBILE_USER_AGENT_REGEX = Pattern.compile("(iPhone;|iPad;|iPhone Simulator;|iPod;|iPod touch;|Linux; U; Android)");
    private static final Pattern ANDROID_CHROME = Pattern.compile("Chrome/[.\\d]* Mobile");
    private static final Pattern OLD_ANDROID = Pattern.compile("Linux; U; Android (?:[23]\\.\\d|4\\.0\\.[12])");
    private static final Pattern ANDROID_FIREFOX = Pattern.compile("\\((Mobile|Android \\d(.\\d)*; (Mobile|Tablet|Mobi));");

    public static boolean isMobileViewRequest(String userAgent) {
        return MobileUtils.isSupportedUserAgent(userAgent);
    }

    public static boolean isSupportedUserAgent(String userAgent) {
        boolean isUserAgentNotBlankAndNotOldAndroid = StringUtils.isNotBlank((CharSequence)userAgent) && !OLD_ANDROID.matcher(userAgent).find();
        boolean isUserAgentMobile = MOBILE_USER_AGENT_REGEX.matcher(userAgent).find() || ANDROID_CHROME.matcher(userAgent).find() || ANDROID_FIREFOX.matcher(userAgent).find();
        boolean isSupportedUserAgent = isUserAgentNotBlankAndNotOldAndroid && isUserAgentMobile;
        return isSupportedUserAgent;
    }

    public static boolean isDesktopSwitchRequired(HttpServletRequest request) {
        return Boolean.valueOf(request.getParameter(DESKTOP_URL_PARAMETER));
    }
}

