/*
 * Decompiled with CFR 0.152.
 */
package de.xalt.confluence.plugins.util;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.xalt.confluence.plugins.model.CroppedImage;
import de.xalt.confluence.plugins.model.ImageResponse;
import de.xalt.confluence.plugins.service.GalleryAttachmentService;
import de.xalt.confluence.plugins.util.ImageScaler;
import de.xalt.confluence.plugins.util.XaltGalleryImageSize;
import java.awt.Rectangle;
import java.awt.color.CMMException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

@Named
public class ImageScalerHelper {
    private static final Logger log = LoggerFactory.getLogger(ImageScalerHelper.class);
    @ComponentImport
    private final AttachmentManager attachmentManager;
    @ComponentImport
    private final LabelManager labelManager;
    @ComponentImport
    private final BootstrapManager bootstrapManager;
    private final ImageScaler imageScaler;
    private final ContentEntityManager contentEntityManager;
    private final GalleryAttachmentService galleryAttachmentService;

    @Inject
    public ImageScalerHelper(AttachmentManager attachmentManager, ImageScaler imageScaler, LabelManager labelManager, BootstrapManager bootstrapManager, @ComponentImport @Qualifier(value="contentEntityManager") ContentEntityManager contentEntityManager, GalleryAttachmentService galleryAttachmentService) {
        this.attachmentManager = attachmentManager;
        this.imageScaler = imageScaler;
        this.labelManager = labelManager;
        this.bootstrapManager = bootstrapManager;
        this.contentEntityManager = contentEntityManager;
        this.galleryAttachmentService = galleryAttachmentService;
    }

    public ImageResponse prepScaleImage(Long pageID, String imageFileName, int galleryWidth, int galleryHeight) {
        ImageResponse scaledImage = null;
        log.debug("Getting content entity of page: " + pageID);
        ContentEntityObject ceo = this.contentEntityManager.getById(pageID.longValue());
        return this.getImageResponse(pageID, imageFileName, galleryWidth, galleryHeight, scaledImage, ceo);
    }

    public ImageResponse prepScaleImage(ContentEntityObject ceo, String imageFileName, int galleryWidth, int galleryHeight) {
        ImageResponse scaledImage = null;
        Long pageID = ceo.getId();
        log.debug("Getting content entity of page: " + pageID);
        return this.getImageResponse(pageID, imageFileName, galleryWidth, galleryHeight, scaledImage, ceo);
    }

    private ImageResponse getImageResponse(Long pageID, String imageFileName, int galleryWidth, int galleryHeight, ImageResponse scaledImage, ContentEntityObject ceo) {
        if (ceo != null) {
            Attachment attachment = this.galleryAttachmentService.getImage(imageFileName, ceo);
            Attachment latestAttachment = attachment != null ? (Attachment)attachment.getLatestVersion() : null;
            XaltGalleryImageSize targetSize = this.getTargetScaleSize(galleryWidth, galleryHeight);
            if (latestAttachment != null && !latestAttachment.isDeleted()) {
                scaledImage = this.scaleImage(latestAttachment, ceo, targetSize);
            }
        } else {
            log.debug("Unable to get ContentEntity: " + pageID);
        }
        return scaledImage;
    }

    public XaltGalleryImageSize getTargetScaleSize(int width, int height) {
        String scaleName = width + "x" + height;
        if (XaltGalleryImageSize.FULL.getScaleName().equals(scaleName)) {
            return XaltGalleryImageSize.FULL;
        }
        if (XaltGalleryImageSize.HALF.getScaleName().equals(scaleName)) {
            return XaltGalleryImageSize.HALF;
        }
        if (XaltGalleryImageSize.FULL_PORTRAIT.getScaleName().equals(scaleName)) {
            return XaltGalleryImageSize.FULL_PORTRAIT;
        }
        if (XaltGalleryImageSize.HALF_PORTRAIT.getScaleName().equals(scaleName)) {
            return XaltGalleryImageSize.HALF_PORTRAIT;
        }
        if (XaltGalleryImageSize.QUARTER_PORTRAIT.getScaleName().equals(scaleName)) {
            return XaltGalleryImageSize.QUARTER_PORTRAIT;
        }
        return XaltGalleryImageSize.QUARTER;
    }

    public Attachment cropImage(CroppedImage croppedImage, Attachment imageAttachment, AbstractPage page) {
        BufferedImage image = null;
        try {
            InputStream imageStream = this.attachmentManager.getAttachmentData(imageAttachment);
            ImageInputStream input = ImageIO.createImageInputStream(imageStream);
            ImageReader reader = ImageIO.getImageReaders(input).next();
            reader.setInput(input);
            ImageReadParam param = reader.getDefaultReadParam();
            if (croppedImage.getX().intValue() < 0) {
                double newXValue = 0.0;
                croppedImage.setX(newXValue);
            }
            if (croppedImage.getY().intValue() < 0) {
                double newYValue = 0.0;
                croppedImage.setY(newYValue);
            }
            param.setSourceRegion(new Rectangle(croppedImage.getX().intValue(), croppedImage.getY().intValue(), croppedImage.getWidth().intValue(), croppedImage.getHeight().intValue()));
            image = reader.read(0, param);
            this.attachmentManager.removeAttachmentWithoutNotifications(imageAttachment);
            Attachment croppedAttachment = this.processCroppedImage((ContentEntityObject)page, image, imageAttachment);
            return croppedAttachment;
        }
        catch (CMMException | IOException | IllegalArgumentException e) {
            log.error("Could not crop image");
            e.printStackTrace();
            return null;
        }
    }

    public ImageResponse scaleImage(Attachment imageAttachment, ContentEntityObject ceo, XaltGalleryImageSize targetSize) {
        BufferedImage image = null;
        if (this.isScalingNeeded(imageAttachment, ceo)) {
            try {
                InputStream imageStream = this.attachmentManager.getAttachmentData(imageAttachment);
                InputStream metaDataImageStream = this.attachmentManager.getAttachmentData(imageAttachment);
                image = this.imageScaler.loadFromStream(imageStream, metaDataImageStream);
            }
            catch (CMMException | IOException | IllegalArgumentException var7) {
                log.warn("Image could not be loaded, image will not be scaled.", (Throwable)var7);
                return new ImageResponse(imageAttachment, null, null, null, null);
            }
        }
        Integer width = 0;
        Integer height = 0;
        if (image != null) {
            width = image.getWidth();
            height = image.getHeight();
            if (!this.isLandscapeImage(image.getWidth(), image.getHeight())) {
                log.debug("The image is a portrait, will proceed to scaling with bigger height: " + targetSize.getHeight() + "x" + targetSize.getWidth());
                targetSize = this.getTargetScaleSize(targetSize.getHeight(), targetSize.getWidth());
            }
        }
        String path = this.setScaledImage(imageAttachment, image, ceo, targetSize);
        String path2x = this.setScaledImage(imageAttachment, image, ceo, targetSize.get2X());
        if (width > 0 && height > 0) {
            if (!StringUtils.isBlank((String)path)) {
                return new ImageResponse(imageAttachment, path, path2x, width, height);
            }
            return new ImageResponse(imageAttachment, null, null, width, height);
        }
        if (!StringUtils.isBlank((String)path)) {
            return new ImageResponse(imageAttachment, path, path2x, null, null);
        }
        return new ImageResponse(imageAttachment, null, null, null, null);
    }

    public String setScaledImage(Attachment imageAttachment, BufferedImage image, ContentEntityObject ceo, XaltGalleryImageSize size) {
        Attachment scaledImageAttachment = ceo.getAttachmentNamed(this.getScaledImageTitle(imageAttachment.getFileName(), size, imageAttachment.getFileExtension()));
        if (image != null) {
            if (scaledImageAttachment == null) {
                log.debug("No scaled image yet. Scaling the image:" + imageAttachment.getFileName());
                scaledImageAttachment = this.processImage(ceo, image, imageAttachment, size);
            } else if (scaledImageAttachment.isDeleted() || !this.scaledImageVersionExists(scaledImageAttachment, imageAttachment)) {
                log.debug("Scaled image was deleted. Scaling the image." + imageAttachment.getFileName());
                this.attachmentManager.removeAttachmentWithoutNotifications(scaledImageAttachment);
                scaledImageAttachment = this.processImage(ceo, image, imageAttachment, size);
            }
        }
        this.addXaltGalleryLabel(scaledImageAttachment);
        return this.getScaledImageDownloadPath(scaledImageAttachment);
    }

    private Attachment processCroppedImage(ContentEntityObject ceo, BufferedImage image, Attachment originalImageAttachment) {
        ByteArrayOutputStream croppedOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, originalImageAttachment.getFileExtension(), croppedOutputStream);
        }
        catch (IOException var7) {
            return originalImageAttachment;
        }
        return this.createAttachment(croppedOutputStream, originalImageAttachment.getFileName(), ceo, originalImageAttachment);
    }

    private Attachment processImage(ContentEntityObject ceo, BufferedImage image, Attachment originalImageAttachment, XaltGalleryImageSize size) {
        ByteArrayOutputStream scaledOutputStream;
        try {
            scaledOutputStream = this.imageScaler.scale(image, size, originalImageAttachment.getFileExtension());
        }
        catch (IOException var7) {
            return originalImageAttachment;
        }
        return scaledOutputStream == null ? originalImageAttachment : this.createAttachment(scaledOutputStream, this.getScaledImageTitle(originalImageAttachment.getFileName(), size, originalImageAttachment.getFileExtension()), ceo, originalImageAttachment);
    }

    private Attachment createAttachment(ByteArrayOutputStream imageOutputStream, String attachmentName, ContentEntityObject ceo, Attachment originalAttachment) {
        ByteArrayInputStream scaledImageInputStream = new ByteArrayInputStream(imageOutputStream.toByteArray());
        Attachment scaledImageAttachment = new Attachment(attachmentName, originalAttachment.getMediaType(), (long)imageOutputStream.size(), this.getCustomVersionCommentForAttachment(originalAttachment));
        scaledImageAttachment.setLastModificationDate(new Date());
        scaledImageAttachment.setCreator(originalAttachment.getCreator());
        scaledImageAttachment.setTitle(attachmentName);
        scaledImageAttachment.getProperties().setLongProperty("HIDDEN", 1L);
        scaledImageAttachment.setMinorEdit(true);
        ceo.addAttachment(scaledImageAttachment);
        try {
            log.debug("Attempting to save scaled attachment: " + attachmentName);
            this.attachmentManager.saveAttachment(scaledImageAttachment, null, (InputStream)scaledImageInputStream, DefaultSaveContext.MINOR_EDIT);
            return scaledImageAttachment;
        }
        catch (IOException var8) {
            log.warn("Scaled attachment: " + attachmentName + " could not be saved", (Throwable)var8);
            return null;
        }
    }

    private void addXaltGalleryLabel(Attachment scaledImageAttachment) {
        boolean xaltGalleryLabelExists;
        if (scaledImageAttachment != null && scaledImageAttachment.getFileName().contains("scaled gallery image") && !(xaltGalleryLabelExists = scaledImageAttachment.getLabels().stream().anyMatch(label -> label.getDisplayTitle().equals("xalt-gallery-scale")))) {
            this.labelManager.addLabel((Labelable)scaledImageAttachment, new Label("xalt-gallery-scale"));
        }
    }

    public Attachment getImage(String imageFilename, ContentEntityObject ceo) {
        Attachment attachment = this.getExistingImage(imageFilename, ceo);
        return attachment != null ? attachment : (Attachment)this.attachmentManager.getAttachmentForDownloadPath(imageFilename).getOrNull();
    }

    private Attachment getExistingImage(String imageFileName, ContentEntityObject ceo) {
        return ceo.getAttachments().stream().filter(attachment -> !attachment.isDeleted() && attachment.getFileName().equalsIgnoreCase(imageFileName)).findFirst().orElse(null);
    }

    private boolean isScalingNeeded(Attachment imageAttachment, ContentEntityObject ceo) {
        return this.isScalingNeeded(imageAttachment, ceo.getAttachmentNamed(this.getScaledImageTitle(imageAttachment.getFileName(), XaltGalleryImageSize.HALF, imageAttachment.getFileExtension()))) || this.isScalingNeeded(imageAttachment, ceo.getAttachmentNamed(this.getScaledImageTitle(imageAttachment.getFileName(), XaltGalleryImageSize.QUARTER, imageAttachment.getFileExtension()))) || this.isScalingNeeded(imageAttachment, ceo.getAttachmentNamed(this.getScaledImageTitle(imageAttachment.getFileName(), XaltGalleryImageSize.HALF_PORTRAIT, imageAttachment.getFileExtension()))) || this.isScalingNeeded(imageAttachment, ceo.getAttachmentNamed(this.getScaledImageTitle(imageAttachment.getFileName(), XaltGalleryImageSize.QUARTER_PORTRAIT, imageAttachment.getFileExtension())));
    }

    private boolean isScalingNeeded(Attachment imageAttachment, Attachment scaledImage) {
        return scaledImage == null || scaledImage.isDeleted() || !this.scaledImageVersionExists(scaledImage, imageAttachment);
    }

    boolean scaledImageVersionExists(Attachment scaledImage, Attachment originalImage) {
        return scaledImage.getVersionComment().equals(this.getCustomVersionCommentForAttachment(originalImage));
    }

    private String getCustomVersionCommentForAttachment(Attachment attachment) {
        return "scaled gallery image from " + attachment.getFileName() + " (" + attachment.getFileSize() + " bytes) for XALT Advanced Gallery macro";
    }

    private String getScaledImageTitle(String imageFileName, XaltGalleryImageSize size, String fileExtension) {
        return imageFileName + " scaled gallery image (" + size.getName() + ")." + fileExtension;
    }

    private String getScaledImageDownloadPath(Attachment attachment) {
        if (attachment != null && attachment.getFileName().contains("scaled gallery image")) {
            return this.bootstrapManager.getWebAppContextPath() + attachment.getDownloadPath();
        }
        return "";
    }

    private boolean isLandscapeImage(Integer width, Integer height) {
        return width > height;
    }
}

