/*
 * Decompiled with CFR 0.152.
 */
package de.xalt.confluence.plugins.service.impl;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.multipart.FilePart;
import de.xalt.confluence.plugins.service.EditImageService;
import de.xalt.confluence.plugins.service.GalleryAttachmentService;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

@ExportAsService(value={EditImageService.class})
@Named(value="editImageService")
public class EditImageServiceImpl
implements EditImageService {
    private static final Logger log = LoggerFactory.getLogger(EditImageServiceImpl.class);
    @ComponentImport
    private final AttachmentManager attachmentManager;
    private final ContentEntityManager contentEntityManager;
    private final GalleryAttachmentService galleryAttachmentService;

    @Inject
    public EditImageServiceImpl(AttachmentManager attachmentManager, @ComponentImport @Qualifier(value="contentEntityManager") ContentEntityManager contentEntityManager, GalleryAttachmentService galleryAttachmentService) {
        this.attachmentManager = attachmentManager;
        this.contentEntityManager = contentEntityManager;
        this.galleryAttachmentService = galleryAttachmentService;
    }

    @Override
    public Attachment cropImage(String fileName, Long pageId, FilePart croppedImageFile) {
        Attachment latestAttachment;
        BufferedImage image = null;
        ContentEntityObject contentEntityObject = this.contentEntityManager.getById(pageId.longValue());
        Attachment imageAttachment = this.galleryAttachmentService.getImage(fileName, contentEntityObject);
        Attachment attachment = latestAttachment = imageAttachment != null ? (Attachment)imageAttachment.getLatestVersion() : null;
        if (latestAttachment != null && !latestAttachment.isDeleted()) {
            try {
                ImageInputStream input = ImageIO.createImageInputStream(croppedImageFile.getInputStream());
                ImageReader reader = ImageIO.getImageReaders(input).next();
                reader.setInput(input);
                image = reader.read(0);
                this.attachmentManager.removeAttachmentWithoutNotifications(imageAttachment);
                Attachment croppedAttachment = this.galleryAttachmentService.processImage(contentEntityObject, image, imageAttachment, "cropped");
                return croppedAttachment;
            }
            catch (Exception e) {
                log.error("Unable to crop image", (Throwable)e);
                return null;
            }
        }
        return null;
    }
}

