/*
 * Decompiled with CFR 0.152.
 */
package de.xalt.confluence.plugins.resources;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.user.User;
import de.xalt.confluence.plugins.exception.DuplicateGalleryNameException;
import de.xalt.confluence.plugins.model.Gallery;
import de.xalt.confluence.plugins.model.GalleryRequest;
import de.xalt.confluence.plugins.model.GallerySettings;
import de.xalt.confluence.plugins.service.GalleryService;
import de.xalt.confluence.plugins.util.XaltGalleryUtil;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

@Path(value="/xalt-gallery")
public class XALTGalleryResource {
    private static final Logger log = LoggerFactory.getLogger(XALTGalleryResource.class);
    private GalleryService galleryService;
    private PermissionManager permissionManager;
    private ContentEntityManager contentEntityManager;

    @Inject
    public XALTGalleryResource(@ComponentImport GalleryService galleryService, @ComponentImport PermissionManager permissionManager, @ComponentImport @Qualifier(value="contentEntityManager") ContentEntityManager contentEntityManager) {
        this.galleryService = galleryService;
        this.permissionManager = permissionManager;
        this.contentEntityManager = contentEntityManager;
    }

    @GET
    @Path(value="/{galleryName}")
    @Produces(value={"application/json"})
    @AnonymousAllowed
    public Response getGallery(@PathParam(value="galleryName") String galleryName, @QueryParam(value="pageId") String pageId) {
        block8: {
            ConfluenceUser user = AuthenticatedUserThreadLocal.get();
            if (StringUtils.isBlank((CharSequence)galleryName)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            Gallery gallery = this.galleryService.getGallery("de.xalt.confluence.plugins.advanced-gallery-macro.xalt-gallery", galleryName);
            GallerySettings setting = this.galleryService.getGallerySettings(galleryName);
            if (gallery == null) {
                log.error("Gallery does not exist in database: " + galleryName + ". Returning blank gallery for no pictures.");
                return Response.ok((Object)new Gallery()).build();
            }
            ObjectMapper objectMapper = new ObjectMapper();
            Map galleryMap = (Map)objectMapper.convertValue((Object)gallery, Map.class);
            if (setting != null) {
                Map gallerySetting = (Map)objectMapper.convertValue((Object)setting, Map.class);
                galleryMap.putAll(gallerySetting);
            }
            ContentEntityObject galleryContentEntity = this.contentEntityManager.getById(Long.parseLong(gallery.getPageId()));
            boolean isSourceGalleryDeleted = false;
            if (galleryContentEntity == null || galleryContentEntity.isDeleted()) {
                isSourceGalleryDeleted = true;
            }
            galleryMap.put("isSourceGalleryDeleted", isSourceGalleryDeleted);
            try {
                ContentEntityObject page;
                Long convertedPageId = Long.parseLong(gallery.getPageId());
                if (!pageId.equals(gallery.getPageId())) {
                    convertedPageId = Long.parseLong(pageId);
                }
                if (this.permissionManager.hasPermission((User)user, Permission.VIEW, (Object)(page = this.contentEntityManager.getById(convertedPageId.longValue())))) {
                    return Response.ok((Object)galleryMap).build();
                }
            }
            catch (NumberFormatException exception) {
                if (!this.permissionManager.hasPermission((User)user, Permission.VIEW, PermissionManager.TARGET_APPLICATION)) break block8;
                return Response.ok((Object)galleryMap).build();
            }
        }
        return Response.status((int)401).build();
    }

    @POST
    @Consumes(value={"application/json"})
    public Response addGallery(GalleryRequest galleryRequest) {
        log.info("Adding gallery to DB");
        Gallery gallery = new Gallery.Builder(galleryRequest).build();
        GallerySettings setting = this.galleryService.getGallerySettings(galleryRequest.getName());
        setting.setDisplayPlainInMobile(galleryRequest.isDisplayPlainInMobile());
        setting.setImagesScaled(false);
        XaltGalleryUtil.checkAndSetGallerySize(gallery);
        try {
            this.galleryService.saveGalleryWithSettings(gallery, setting, "de.xalt.confluence.plugins.advanced-gallery-macro.xalt-gallery", gallery.getName());
        }
        catch (DuplicateGalleryNameException dgne) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (Exception e) {
            log.error("Error saving Gallery");
            log.error(e.getMessage());
        }
        log.info("Gallery saved!");
        return Response.ok().build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Path(value="/{galleryName}")
    public Response updateGallery(GalleryRequest galleryRequest, @PathParam(value="galleryName") String galleryName) {
        Gallery gallery = new Gallery.Builder(galleryRequest).build();
        GallerySettings setting = this.galleryService.getGallerySettings(galleryRequest.getName());
        setting.setDisplayPlainInMobile(galleryRequest.isDisplayPlainInMobile());
        setting.setImagesScaled(false);
        log.info("Updating gallery: " + gallery.getName());
        XaltGalleryUtil.checkAndSetGallerySize(gallery);
        try {
            if (!galleryName.equals(gallery.getName())) {
                this.galleryService.saveGalleryWithSettings(gallery, setting, "de.xalt.confluence.plugins.advanced-gallery-macro.xalt-gallery", gallery.getName());
                this.galleryService.removeGalleryWithSetting("de.xalt.confluence.plugins.advanced-gallery-macro.xalt-gallery", galleryName);
            } else {
                this.galleryService.updateGalleryWithSetting(gallery, setting, "de.xalt.confluence.plugins.advanced-gallery-macro.xalt-gallery", gallery.getName());
            }
        }
        catch (DuplicateGalleryNameException dgne) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (Exception e) {
            log.error("Error updating Gallery");
            log.error(e.getMessage());
        }
        log.info("Gallery updated: " + gallery.getName());
        return Response.ok().build();
    }
}

