/*
 * Decompiled with CFR 0.152.
 */
package de.xalt.confluence.plugins.repository.impl;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import de.xalt.confluence.plugins.model.Picture;
import de.xalt.confluence.plugins.repository.PictureRepository;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class PictureRepositoryImpl
implements PictureRepository {
    @Autowired
    private BandanaManager bandanaManager;

    @Override
    public void save(String context, Picture type, String id) throws Exception {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(context), id, (Object)type);
    }

    @Override
    public Picture get(String context, String id) throws Exception {
        return (Picture)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(context), id);
    }

    @Override
    public void delete(String context, String id) throws Exception {
        this.bandanaManager.removeValue((BandanaContext)new ConfluenceBandanaContext(context), id);
    }

    @Override
    public List<Picture> getAllPictures(String context) {
        ArrayList<Picture> pictureList = new ArrayList<Picture>();
        Iterable attachmentIds = this.bandanaManager.getKeys((BandanaContext)new ConfluenceBandanaContext(context));
        for (String attachmentId : attachmentIds) {
            Object object = this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(context), attachmentId);
            if (!(object instanceof Picture)) continue;
            pictureList.add((Picture)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(context), attachmentId));
        }
        return pictureList;
    }

    @Override
    public Map<Long, Picture> getAllPicturesAsMap(String context) {
        HashMap<Long, Picture> pictureMap = new HashMap<Long, Picture>();
        Iterable attachmentIds = this.bandanaManager.getKeys((BandanaContext)new ConfluenceBandanaContext(context));
        for (String attachmentId : attachmentIds) {
            Object object = this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(context), attachmentId);
            if (!(object instanceof Picture)) continue;
            pictureMap.put(Long.parseLong(attachmentId), (Picture)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(context), attachmentId));
        }
        return pictureMap;
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }
}

