/*
 * Decompiled with CFR 0.152.
 */
package de.xalt.confluence.plugins.repository.impl;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.google.gson.Gson;
import de.xalt.confluence.plugins.model.Gallery;
import de.xalt.confluence.plugins.model.GallerySettings;
import de.xalt.confluence.plugins.model.Picture;
import de.xalt.confluence.plugins.repository.GalleryRepository;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class GalleryRepositoryImpl
implements GalleryRepository {
    private static final Logger logger = LoggerFactory.getLogger(GalleryRepositoryImpl.class);
    @ConfluenceImport
    private BandanaManager bandanaManager;

    @Autowired
    public GalleryRepositoryImpl(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    @Override
    public void save(Gallery type, String context, String id) throws Exception {
        logger.debug("Saving gallery: " + id);
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(context), id, (Object)type);
    }

    @Override
    public void saveSettings(String setting, String context, String id) throws Exception {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(context), id, (Object)setting);
    }

    @Override
    public void remove(String context, String id) {
        this.bandanaManager.removeValue((BandanaContext)new ConfluenceBandanaContext(context), id);
    }

    @Override
    public Gallery get(String context, String id) {
        Object gallery = this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(context), id);
        return this.createOldGalleryToNewGallery(gallery);
    }

    @Override
    public GallerySettings getSettings(String context, String id) {
        GallerySettings setting = new GallerySettings();
        String gallerySettingStr = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(context), id);
        if (!StringUtils.isEmpty((CharSequence)gallerySettingStr)) {
            Gson gson = new Gson();
            setting = gson.fromJson(gallerySettingStr, GallerySettings.class);
        }
        return setting;
    }

    @Override
    public List<Gallery> getAllGalleries(String context) {
        ArrayList<Gallery> galleryList = new ArrayList<Gallery>();
        Iterable galleryIds = this.bandanaManager.getKeys((BandanaContext)new ConfluenceBandanaContext(context));
        for (String galleryId : galleryIds) {
            Object object = this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(context), galleryId);
            Gallery galleryToAdd = this.createOldGalleryToNewGallery(object);
            galleryList.add(galleryToAdd);
        }
        return galleryList;
    }

    @Override
    public int getTotalImages(String context) {
        int totalImages = 0;
        List<Gallery> galleryList = this.getAllGalleries(context);
        for (Gallery gal : galleryList) {
            totalImages += gal.getPictures().size();
        }
        return totalImages;
    }

    private Gallery createOldGalleryToNewGallery(Object oldGallery) {
        if (oldGallery == null) {
            return null;
        }
        Class<?> oldObjectClass = oldGallery.getClass();
        Gallery newGallery = new Gallery();
        try {
            logger.debug("attempting cast gallery");
            newGallery.setName((String)this.getFieldValue(oldGallery, oldObjectClass, "name"));
            newGallery.setDisplayType((String)this.getFieldValue(oldGallery, oldObjectClass, "displayType"));
            newGallery.setGalleryWidth((String)this.getFieldValue(oldGallery, oldObjectClass, "galleryWidth"));
            newGallery.setGalleryHeight((String)this.getFieldValue(oldGallery, oldObjectClass, "galleryHeight"));
            newGallery.setThumbnailPercentage((String)this.getFieldValue(oldGallery, oldObjectClass, "thumbnailPercentage"));
            newGallery.setSpaceKey((String)this.getFieldValue(oldGallery, oldObjectClass, "spaceKey"));
            newGallery.setPageId((String)this.getFieldValue(oldGallery, oldObjectClass, "pageId"));
            newGallery.setMacroId((String)this.getFieldValue(oldGallery, oldObjectClass, "macroId"));
            newGallery.setSortingType((String)this.getFieldValue(oldGallery, oldObjectClass, "sortingType"));
            newGallery.setSavedFromDraft((Boolean)this.getFieldValue(oldGallery, oldObjectClass, "savedFromDraft"));
            newGallery.setShowCopyright((Boolean)this.getFieldValue(oldGallery, oldObjectClass, "showCopyright"));
            ArrayList<Picture> newPictureList = new ArrayList<Picture>();
            List pictureObjects = (List)this.getFieldValue(oldGallery, oldObjectClass, "pictures");
            logger.debug("attempting to cast pictures");
            for (Object pictureObject : pictureObjects) {
                Class<?> oldPictureClass = pictureObject.getClass();
                Picture newPictureObject = new Picture();
                newPictureObject.setId((String)this.getFieldValue(pictureObject, oldPictureClass, "id"));
                newPictureObject.setSpaceKey((String)this.getFieldValue(pictureObject, oldPictureClass, "spaceKey"));
                newPictureObject.setFileName((String)this.getFieldValue(pictureObject, oldPictureClass, "fileName"));
                newPictureObject.setContentId((String)this.getFieldValue(pictureObject, oldPictureClass, "contentId"));
                newPictureObject.setIndex((Integer)this.getFieldValue(pictureObject, oldPictureClass, "index"));
                newPictureObject.setWhen((String)this.getFieldValue(pictureObject, oldPictureClass, "when"));
                newPictureObject.setMediaType((String)this.getFieldValue(pictureObject, oldPictureClass, "mediaType"));
                newPictureObject.setLinkDownload((String)this.getFieldValue(pictureObject, oldPictureClass, "linkDownload"));
                newPictureObject.setCaptions((HashMap)this.getFieldValue(pictureObject, oldPictureClass, "captions"));
                newPictureObject.setCopyright((String)this.getFieldValue(pictureObject, oldPictureClass, "copyright"));
                newPictureObject.setScaledImageURL((String)this.getFieldValue(pictureObject, oldPictureClass, "scaledImageURL"));
                newPictureObject.setScaled2xImageURL((String)this.getFieldValue(pictureObject, oldPictureClass, "scaled2xImageURL"));
                newPictureObject.setOriginalWidth((Integer)this.getFieldValue(pictureObject, oldPictureClass, "originalWidth"));
                newPictureObject.setOriginalHeight((Integer)this.getFieldValue(pictureObject, oldPictureClass, "originalHeight"));
                newPictureList.add(newPictureObject);
            }
            newGallery.setPictures(newPictureList);
            newGallery.setGallerySize((String)this.getFieldValueOrIgnore(oldGallery, oldObjectClass, "gallerySize", null));
            return newGallery;
        }
        catch (Exception e) {
            logger.debug("Failed to re-cast gallery via reflection.");
            return (Gallery)oldGallery;
        }
    }

    private Object getFieldValueOrIgnore(Object oldObject, Class oldClass, String fieldName, Object defaultValue) {
        try {
            return this.getFieldValue(oldObject, oldClass, fieldName);
        }
        catch (Exception e) {
            logger.debug("Ignoring field: " + fieldName);
            return defaultValue;
        }
    }

    private Object getFieldValue(Object oldObject, Class oldClass, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        try {
            Field data = oldClass.getDeclaredField(fieldName);
            data.setAccessible(true);
            return data.get(oldObject);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            logger.error("Unable to acquire field: " + fieldName);
            throw e;
        }
    }
}

