/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.dmnpluginenterprise.rest;

import com.atlassian.confluence.security.Permission;
import de.viadee.confluence.enterprisecore.model.SpaceAccessModel;
import de.viadee.confluence.enterprisecore.rest.SpaceAccessResource;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;

@Path(value="/spaces")
public class SpaceAccessController {
    public static final String PATH = "/spaces";
    private final SpaceAccessResource spaceAccessResource;
    private final AuthValidator authValidator;

    @Inject
    public SpaceAccessController(SpaceAccessResource spaceAccessResource, AuthValidator authValidator) {
        this.spaceAccessResource = spaceAccessResource;
        this.authValidator = authValidator;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getAllWhitelistedSpaces(@Context HttpServletRequest request) {
        this.authValidator.createContext(request).checkConfluenceAdminStatus();
        return this.spaceAccessResource.getAllWhitelistedSpaces();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{key}")
    public Response isSpaceInWhitelistedSpaces(@Context HttpServletRequest request, @PathParam(value="key") String spaceKey) {
        this.authValidator.createContext(request).checkAuthentication().checkSpacePermission(spaceKey, Permission.VIEW);
        return this.spaceAccessResource.isSpaceInWhitelistedSpaces(spaceKey);
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response addSpaceToWhiteList(@Context HttpServletRequest request, SpaceAccessModel space) {
        this.authValidator.createContext(request).checkConfluenceAdminStatus();
        return this.spaceAccessResource.addSpaceToWhitelist(space);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/{key}")
    public Response removeSpaceFromWhitelistByKey(@Context HttpServletRequest request, @PathParam(value="key") String spaceKey) {
        this.authValidator.createContext(request).checkConfluenceAdminStatus();
        return this.spaceAccessResource.removeSpaceFromWhitelistByKey(spaceKey);
    }
}

