/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.dmnpluginenterprise.rest;

import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import de.viadee.confluence.enterprisecore.rest.AppConfigResource;
import de.viadee.confluence.enterprisecore.rest.GeneralAppConfigResource;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;

@Path(value="/generalConfig")
@AnonymousSiteAccess
public class GeneralAppConfigController {
    private final GeneralAppConfigResource generalAppConfigResource;
    private final AuthValidator authValidator;

    @Inject
    public GeneralAppConfigController(GeneralAppConfigResource generalAppConfigResource, AuthValidator authValidator) {
        this.generalAppConfigResource = generalAppConfigResource;
        this.authValidator = authValidator;
    }

    @PUT
    @Path(value="/config")
    @Consumes(value={"application/json"})
    public Response putConfig(@Context HttpServletRequest request, AppConfigResource.GeneralConfig config) {
        this.authValidator.createContext(request).checkConfluenceAdminStatus();
        return this.generalAppConfigResource.putConfig(config);
    }
}

